/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util.builder;

import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Match;
import com.github.cukedoctor.api.model.Result;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.api.model.Type;
import com.github.cukedoctor.util.builder.ScenarioBuilder;
import com.github.cukedoctor.util.builder.StepBuilder;
import java.util.ArrayList;

public class FeatureBuilder {
    private Feature feature;
    private static FeatureBuilder instance;

    private FeatureBuilder(Feature feature) {
        this.feature = feature;
    }

    private Feature getFeature() {
        return this.feature;
    }

    public static synchronized FeatureBuilder instance() {
        instance = new FeatureBuilder(new Feature());
        return instance;
    }

    public static synchronized FeatureBuilder instance(Feature feature) {
        instance = new FeatureBuilder(feature);
        return instance;
    }

    public FeatureBuilder id(String id) {
        this.feature.setId(id);
        return instance;
    }

    public FeatureBuilder name(String name) {
        this.feature.setName(name);
        return instance;
    }

    public FeatureBuilder uri(String uri) {
        this.feature.setUri(uri);
        return instance;
    }

    public FeatureBuilder description(String desc) {
        this.feature.setDescription(desc);
        return instance;
    }

    public FeatureBuilder scenario(Scenario scenario) {
        if (this.feature.getElements() == null) {
            this.feature.setElements(new ArrayList<Scenario>());
        }
        this.feature.getElements().add(scenario);
        return instance;
    }

    public FeatureBuilder keyword(String keyword) {
        this.feature.setKeyword(keyword);
        return instance;
    }

    public FeatureBuilder tag(String tag) {
        if (this.feature.hasTags()) {
            this.feature.getTags().add(new Tag(tag));
            return this;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(1);
        tags.add(new Tag(tag));
        this.feature.setTags(tags);
        return this;
    }

    public Feature build() {
        this.feature.initScenarios();
        this.feature.processSteps();
        return instance.getFeature();
    }

    public Feature aFeatureWithTwoScenarios() {
        Feature feature = FeatureBuilder.instance().description("Feature description").scenario(ScenarioBuilder.instance().name("scenario 1").description("description").keyword("Scenario").type(Type.scenario).build()).scenario(ScenarioBuilder.instance().name("scenario 2").description("description 2").keyword("Scenario").type(Type.scenario).build()).name("Feature name").build();
        return feature;
    }

    public Feature aFeatureWithOneScenarioWithOnePassingStep() {
        Feature feature = FeatureBuilder.instance().description("Feature description").scenario(ScenarioBuilder.instance().name("scenario").description("description").keyword("Scenario").type(Type.scenario).step(StepBuilder.instance().name("passing step").result(new Result(Status.passed)).keyword("Given").build()).build()).name("Feature name").build();
        return feature;
    }

    public Feature aFeatureWithOneScenarioWithOnePassingAndOneFailingStep() {
        Feature feature = FeatureBuilder.instance().description("Feature description").scenario(ScenarioBuilder.instance().name("scenario").description("description").keyword("Scenario").type(Type.scenario).step(StepBuilder.instance().name("passing step").result(new Result(Status.passed)).match(new Match("match 1")).keyword("Given").build()).step(StepBuilder.instance().name("failing step").result(new Result(Status.failed)).match(new Match("match 2")).keyword("When").build()).build()).name("Feature name").build();
        return feature;
    }

    public Feature aFeatureWithOneScenarioWithMultipleSteps() {
        Feature feature = FeatureBuilder.instance().description("Feature description").scenario(ScenarioBuilder.instance().name("scenario").description("description").keyword("Scenario").type(Type.scenario).step(StepBuilder.instance().name("passing step").result(new Result(Status.passed)).match(new Match("match 1")).keyword("Given").build()).step(StepBuilder.instance().name("failing step").result(new Result(Status.failed)).match(new Match("match 2")).keyword("When").build()).step(StepBuilder.instance().name("pending step").result(new Result(Status.pending)).match(new Match("match 3")).keyword("When").build()).step(StepBuilder.instance().name("missing step").result(new Result(Status.missing)).match(new Match("match 4")).keyword("When").build()).step(StepBuilder.instance().name("undefined step").result(new Result(Status.undefined)).match(new Match("match 5")).keyword("When").build()).step(StepBuilder.instance().name("skipped step").result(new Result(Status.skipped)).match(new Match("match 6")).keyword("Then").build()).build()).name("Feature name").build();
        return feature;
    }

    public Feature aFeatureWithMultipleScenariosAndSteps() {
        Scenario scenario1 = ScenarioBuilder.instance().name("scenario").description("description").keyword("Scenario").type(Type.scenario).step(StepBuilder.instance().name("passing step").result(new Result(Status.passed)).match(new Match("match 1")).keyword("Given").build()).step(StepBuilder.instance().name("failing step").result(new Result(Status.failed)).match(new Match("match 2")).keyword("When").build()).build();
        Scenario scenario2 = ScenarioBuilder.instance().name("scenario").description("description").keyword("Scenario").type(Type.scenario).step(StepBuilder.instance().name("skipped step").result(new Result(Status.skipped)).match(new Match("match 6")).keyword("Then").build()).build();
        Scenario scenario3 = ScenarioBuilder.instance().name("scenario").description("description").keyword("Scenario").type(Type.scenario).step(StepBuilder.instance().name("undefined step").result(new Result(Status.undefined)).match(new Match("match1")).keyword("Given").build()).build();
        Feature feature = FeatureBuilder.instance().description("Feature description").scenario(scenario1).scenario(scenario2).scenario(scenario3).name("Feature name").build();
        return feature;
    }

    public Feature aFeatureWithNoScenarios() {
        return FeatureBuilder.instance().description("Feature description").name("Feature name").build();
    }
}

