/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.builder;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.builder.AttributesBuilder;
import com.github.cukedoctor.builder.AttributesBuilderImpl;
import com.github.cukedoctor.markup.Asciidoc;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;

public class CukedoctorDocumentBuilderImpl
extends AsciiDocBuilder
implements CukedoctorDocumentBuilder {
    private final int initialTitleNestingLevel;
    private AttributesBuilder attrsBuilder;
    private int currentTitleNestingLevel;

    public CukedoctorDocumentBuilderImpl() {
        this(0);
    }

    private CukedoctorDocumentBuilderImpl(int initialTitleNestingLevel) {
        this.initialTitleNestingLevel = initialTitleNestingLevel;
        this.initialiseTitleNesting();
    }

    @Override
    public AttributesBuilder attributes() {
        if (this.attrsBuilder == null) {
            this.attrsBuilder = new AttributesBuilderImpl(this);
        }
        return this.attrsBuilder;
    }

    @Override
    public CukedoctorDocumentBuilder sideBarBlock(String text) {
        this.delimitedTextLine(Asciidoc.SIDEBAR_BLOCK, text);
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder append(Object ... text) {
        if (Assert.notEmpty(text)) {
            for (Object o : text) {
                if (!o.equals(Constants.newLine()) && !Assert.hasText(o.toString())) continue;
                this.documentBuilder.append(o.toString());
            }
        }
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder textLine(String text) {
        if (Constants.newLine().equals(text) || Assert.hasText(text)) {
            super.textLine(text);
        }
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder sectionTitleLevel5(String title) {
        this.documentBuilder.append("====== ").append(title).append(this.newLine);
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder title(String title) {
        switch (this.currentTitleNestingLevel) {
            case 0: {
                this.documentTitle(title);
                break;
            }
            case 1: {
                this.sectionTitleLevel1(title);
                break;
            }
            case 2: {
                this.sectionTitleLevel2(title);
                break;
            }
            case 3: {
                this.sectionTitleLevel3(title);
                break;
            }
            case 4: {
                this.sectionTitleLevel4(title);
                break;
            }
            case 5: {
                this.sectionTitleLevel5(title);
            }
        }
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder nestTitle() {
        this.checkNestingOverflow();
        ++this.currentTitleNestingLevel;
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder unNestTitle() {
        if (this.currentTitleNestingLevel == this.initialTitleNestingLevel) {
            throw new NestingUnderflowException(this.initialTitleNestingLevel);
        }
        --this.currentTitleNestingLevel;
        return this;
    }

    @Override
    public CukedoctorDocumentBuilder titleThenNest(String title) {
        return this.title(title).nestTitle();
    }

    @Override
    public void clear() {
        this.documentBuilder = new StringBuilder();
        this.initialiseTitleNesting();
    }

    @Override
    public CukedoctorDocumentBuilder createNestedBuilder() {
        this.checkNestingOverflow();
        return new CukedoctorDocumentBuilderImpl(this.currentTitleNestingLevel + 1);
    }

    @Override
    public CukedoctorDocumentBuilder createPeerBuilder() {
        return new CukedoctorDocumentBuilderImpl(this.currentTitleNestingLevel);
    }

    private void checkNestingOverflow() {
        if (this.currentTitleNestingLevel == 5) {
            throw new NestingOverflowException();
        }
    }

    private void initialiseTitleNesting() {
        this.currentTitleNestingLevel = this.initialTitleNestingLevel;
    }

    public class NestingUnderflowException
    extends RuntimeException {
        public NestingUnderflowException(int currentLevel) {
            super(String.format("Nesting is current at Level %s, the top-most allowed for this instance. You cannot un-nest above this level.", currentLevel));
        }
    }

    public class NestingOverflowException
    extends RuntimeException {
        public NestingOverflowException() {
            super("Nesting is currently at Section Title Level 5 (the deepest AsciiDoc allows). You cannot nest further titles below this level.");
        }
    }
}

