/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util;

import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.renderer.BaseRenderer;
import com.github.cukedoctor.util.DefaultImplementationInstantiationException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Function;

public final class ServiceLoaderUtil<R extends BaseRenderer> {
    private final Function<Class<R>, Iterator<R>> loader;

    public ServiceLoaderUtil() {
        this((Class<R> c) -> ServiceLoader.load(c).iterator());
    }

    public ServiceLoaderUtil(Iterable<R> services) {
        this((Class<R> x) -> services.iterator());
    }

    public ServiceLoaderUtil(Function<Class<R>, Iterator<R>> loader) {
        this.loader = loader;
    }

    public R load(Class<R> service, Class<? extends R> defaultImplementation, CukedoctorConfig cukedoctorConfig, Class<? extends R> ... except) {
        HashSet<Class<R>> exceptions = new HashSet<Class<R>>(Arrays.asList(except));
        Iterator<R> services = this.loader.apply(service);
        while (services.hasNext()) {
            BaseRenderer candidate = (BaseRenderer)services.next();
            if (exceptions.contains(candidate.getClass())) continue;
            candidate.setCukedoctorConfig(cukedoctorConfig);
            return (R)candidate;
        }
        try {
            BaseRenderer defaultImpl = (BaseRenderer)defaultImplementation.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            defaultImpl.setCukedoctorConfig(cukedoctorConfig);
            return (R)defaultImpl;
        }
        catch (Throwable t) {
            throw new DefaultImplementationInstantiationException(defaultImplementation, t);
        }
    }

    public R initialise(Class<R> service, Class<? extends R> defaultImplementation, I18nLoader i18n, DocumentAttributes attributes, CukedoctorConfig cukedoctorConfig, Class<? extends R> ... except) {
        R renderer = this.load(service, defaultImplementation, cukedoctorConfig, except);
        renderer.setDocumentAttributes(attributes);
        renderer.setI18n(i18n);
        renderer.setCukedoctorConfig(cukedoctorConfig);
        return renderer;
    }
}

