/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.cukedoctor.api.ScenarioResults;
import com.github.cukedoctor.api.StepResults;
import com.github.cukedoctor.api.model.Comment;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.util.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Feature
implements Comparable<Feature> {
    private static final Logger log = LoggerFactory.getLogger(Feature.class);
    private String id;
    private String name;
    private String uri;
    private String description;
    private String keyword;
    private List<Scenario> elements = new ArrayList<Scenario>();
    private List<Scenario> scenarios = new ArrayList<Scenario>();
    private List<Tag> tags = new ArrayList<Tag>();
    private StepResults stepResults;
    private ScenarioResults scenarioResults;
    private List<Comment> comments;
    @JsonIgnore
    private String language;
    @JsonIgnore
    private Integer order;
    @JsonIgnore
    private boolean backgroundRendered;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public boolean hasTags() {
        return Assert.notEmpty(this.tags);
    }

    public boolean hasScenarios() {
        return !this.elements.isEmpty();
    }

    public Status getStatus() {
        return Assert.notEmpty(this.scenarioResults.getFailedScenarios()) ? Status.failed : Status.passed;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Scenario> getElements() {
        return this.elements;
    }

    public void setElements(List<Scenario> elements) {
        this.elements = elements;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public StepResults getStepResults() {
        return this.stepResults;
    }

    public ScenarioResults getScenarioResults() {
        return this.scenarioResults;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    public boolean isBackgroundRendered() {
        return this.backgroundRendered;
    }

    public void setBackgroundRendered(boolean backgroundRendered) {
        this.backgroundRendered = backgroundRendered;
    }

    @Deprecated
    public Integer getNumberOfScenarios() {
        Integer result = 0;
        if (this.scenarios != null) {
            ArrayList<Scenario> elementList = new ArrayList<Scenario>();
            for (Scenario element : this.scenarios) {
                if (element.hasExamples()) continue;
                elementList.add(element);
            }
            result = elementList.size();
        }
        return result;
    }

    public Integer getNumberOfSteps() {
        return this.stepResults.getNumberOfSteps();
    }

    public Integer getNumberOfPasses() {
        return this.stepResults.getNumberOfPasses();
    }

    public Integer getNumberOfFailures() {
        return this.stepResults.getNumberOfFailures();
    }

    public Integer getNumberOfPending() {
        return this.stepResults.getNumberOfPending();
    }

    public Integer getNumberOfSkipped() {
        return this.stepResults.getNumberOfSkipped();
    }

    public Integer getNumberOfMissing() {
        return this.stepResults.getNumberOfMissing();
    }

    public Integer getNumberOfUndefined() {
        return this.stepResults.getNumberOfUndefined();
    }

    public String getDurationOfSteps() {
        return this.stepResults.getTotalDurationAsString();
    }

    public Integer getNumberOfScenariosPassed() {
        return this.scenarioResults.getNumberOfScenariosPassed();
    }

    public Integer getNumberOfScenariosFailed() {
        return this.scenarioResults.getNumberOfScenariosFailed();
    }

    public List<Scenario> getScenarios() {
        return this.scenarios;
    }

    public void initScenarios() {
        if (this.elements != null) {
            for (Scenario element : this.elements) {
                this.scenarios.add(element);
            }
        }
    }

    public void processSteps() {
        if (!this.isCucumberFeature()) {
            return;
        }
        ArrayList<Step> allSteps = new ArrayList<Step>();
        HashMap<Status, AtomicInteger> statusCounter = new HashMap<Status, AtomicInteger>();
        for (Status status : Status.values()) {
            statusCounter.put(status, new AtomicInteger(0));
        }
        ArrayList<Scenario> passedScenarios = new ArrayList<Scenario>();
        ArrayList<Scenario> failedScenarios = new ArrayList<Scenario>();
        long totalDuration = 0L;
        if (this.scenarios != null) {
            for (Scenario scenario : this.scenarios) {
                if (scenario.hasExamples()) continue;
                this.calculateScenarioStats(passedScenarios, failedScenarios, scenario);
                if (!scenario.hasSteps()) continue;
                for (Step step : scenario.getSteps()) {
                    allSteps.add(step);
                    ((AtomicInteger)statusCounter.get((Object)step.getStatus())).incrementAndGet();
                    totalDuration += step.getDuration().longValue();
                }
            }
        }
        this.scenarioResults = new ScenarioResults(passedScenarios, failedScenarios);
        this.stepResults = new StepResults(allSteps, statusCounter, totalDuration);
    }

    private void calculateScenarioStats(List<Scenario> passedScenarios, List<Scenario> failedScenarios, Scenario element) {
        if (element.isBackground()) {
            return;
        }
        if (element.getStatus() == Status.passed) {
            passedScenarios.add(element);
        } else if (element.getStatus() == Status.failed) {
            failedScenarios.add(element);
        }
    }

    public boolean isCucumberFeature() {
        return this.getName() != null && this.getKeyword() != null && this.elements != null && !this.elements.isEmpty();
    }

    public String getLanguage() {
        if (this.language == null && this.comments != null) {
            this.language = this.stringExtractedFrom(this.comments, comment -> comment.getLanguage().orElse(null));
        }
        if (this.language == null && this.hasTags()) {
            this.language = this.stringExtractedFrom(this.getTags(), tag -> tag.getLanguage().orElse(null));
        }
        if (this.language == null) {
            this.language = "";
        }
        return this.language;
    }

    public int getOrder() {
        if (this.order == null && this.comments != null) {
            this.order = this.tryOrderExtractedFrom(this.comments, comment -> comment.getOrder().orElse(null));
        }
        if (this.order == null && this.hasTags()) {
            this.order = this.tryOrderExtractedFrom(this.getTags(), tag -> tag.getOrder().orElse(null));
        }
        if (this.order == null) {
            this.order = Integer.MAX_VALUE;
        }
        return this.order;
    }

    private <T> String stringExtractedFrom(List<T> elements, Function<T, String> extractor) {
        return elements.stream().map(extractor).filter(Assert::hasText).findFirst().orElse(null);
    }

    private <T> Integer tryOrderExtractedFrom(List<T> elements, Function<T, String> extractor) {
        String orderAsString = this.stringExtractedFrom(elements, extractor);
        try {
            return Integer.parseInt(orderAsString);
        }
        catch (Exception e) {
            log.warn("Could not get order of feature {} from {} cause: {}", new Object[]{this.name, orderAsString, e.getMessage()});
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature feature = (Feature)o;
        return Objects.equals(this.id, feature.id);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 42;
    }

    public boolean hasIgnoreDocsTag() {
        if (this.hasTags()) {
            for (Tag tag : this.tags) {
                if (!"@skipDocs".equalsIgnoreCase(tag.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Feature other) {
        int result = Integer.compare(this.getOrder(), other.getOrder());
        if (result == 0) {
            result = this.name.compareTo(other.getName());
        }
        return result;
    }

    public Scenario getScenarioByName(String name) {
        if (Assert.hasText(name) && this.hasScenarios()) {
            for (Scenario scenario : this.scenarios) {
                if (!Assert.hasText(scenario.getName()) || !scenario.getName().trim().equals(name)) continue;
                return scenario;
            }
        }
        return null;
    }

    public boolean hasTag(String pattern) {
        return this.extractTag(pattern).isPresent();
    }

    public Optional<String> extractTag(String pattern) {
        if (!this.hasTags()) {
            return Optional.empty();
        }
        return this.getTags().stream().map(tag -> tag.extractPattern(pattern)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

