/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.cukedoctor.util.Assert;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Tag {
    private String name;

    public Tag() {
    }

    public Tag(String name) {
        this.name = name;
    }

    public Optional<String> extractPattern(String pattern) {
        int indexOfOrder = this.name.indexOf(pattern);
        if (Assert.hasText(this.name) && indexOfOrder != -1) {
            return Optional.of(this.name.substring(indexOfOrder + pattern.length()).trim());
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOrder() {
        return this.getOrder().isPresent();
    }

    public Optional<String> getOrder() {
        return this.extractPattern("@order-");
    }

    public boolean isDiscrete() {
        return this.extractPattern("@asciidoc").isPresent();
    }

    public boolean isLanguage() {
        return this.getLanguage().isPresent();
    }

    public Optional<String> getLanguage() {
        return this.extractPattern("@language-");
    }
}

