/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.converter;

import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.renderer.CukedoctorFeatureRenderer;
import com.github.cukedoctor.renderer.CukedoctorHeaderRenderer;
import com.github.cukedoctor.renderer.CukedoctorSummaryRenderer;
import com.github.cukedoctor.spi.FeatureRenderer;
import com.github.cukedoctor.spi.HeaderRenderer;
import com.github.cukedoctor.spi.SummaryRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.FileUtil;
import com.github.cukedoctor.util.ServiceLoaderUtil;
import java.util.Collections;
import java.util.List;

public class CukedoctorConverterImpl
implements CukedoctorConverter {
    private List<Feature> features;
    private DocumentAttributes documentAttributes;
    private String filename;
    private CukedoctorDocumentBuilder docBuilder;
    private I18nLoader i18n;
    private SummaryRenderer summaryRenderer;
    private FeatureRenderer featureRenderer;
    private HeaderRenderer headerRenderer;
    private CukedoctorConfig cukedoctorConfig;

    public CukedoctorConverterImpl(List<Feature> features, DocumentAttributes attrs) {
        this(features, attrs, new CukedoctorConfig());
    }

    public CukedoctorConverterImpl(List<Feature> features, DocumentAttributes attrs, CukedoctorConfig cukedoctorConfig) {
        this(features, attrs, cukedoctorConfig, CukedoctorDocumentBuilder.Factory.newInstance());
    }

    public CukedoctorConverterImpl(List<Feature> features, DocumentAttributes attrs, CukedoctorConfig cukedoctorConfig, CukedoctorDocumentBuilder docBuilder) {
        this.cukedoctorConfig = cukedoctorConfig;
        this.features = features;
        Collections.sort(this.features);
        this.documentAttributes = attrs;
        this.docBuilder = docBuilder;
        this.i18n = I18nLoader.newInstance(features);
        this.loadRenderers();
    }

    private void loadRenderers() {
        this.headerRenderer = new ServiceLoaderUtil<CukedoctorHeaderRenderer>().initialise(HeaderRenderer.class, CukedoctorHeaderRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
        this.summaryRenderer = new ServiceLoaderUtil<CukedoctorSummaryRenderer>().initialise(SummaryRenderer.class, CukedoctorSummaryRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
        this.featureRenderer = new ServiceLoaderUtil<CukedoctorFeatureRenderer>().initialise(FeatureRenderer.class, CukedoctorFeatureRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
    }

    @Override
    public DocumentAttributes getDocumentAttributes() {
        return this.documentAttributes;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.features;
    }

    @Override
    public String getDocumentation() {
        return this.docBuilder.toString();
    }

    @Override
    public synchronized String renderDocumentation() {
        System.setProperty("cukedoctor.stopwatch", String.valueOf(System.currentTimeMillis()));
        this.docBuilder.clear();
        this.addCustomPdfTheme();
        this.renderAttributes();
        this.docBuilder.newLine();
        this.docBuilder.title(Constants.Markup.bold(this.getDocumentationTitle()));
        this.renderIntro();
        if (!this.cukedoctorConfig.isHideSummarySection().booleanValue()) {
            this.renderSummary();
        } else {
            this.docBuilder.newLine();
        }
        this.renderFeatures(this.features);
        return this.docBuilder.toString();
    }

    private void renderIntro() {
        List<String> files = FileUtil.findFiles(this.cukedoctorConfig.getIntroChapterDir(), "cukedoctor-intro.adoc", true, this.cukedoctorConfig.getIntroChapterRelativePath());
        if (files != null && !files.isEmpty()) {
            String introPath = files.get(0);
            introPath = introPath.replaceAll("\\\\", "/");
            this.docBuilder.append("include::", introPath, "[leveloffset=+1]", Constants.newLine(), Constants.newLine());
        }
    }

    @Override
    public String getDocumentationTitle() {
        if (this.documentAttributes != null && Assert.hasText(this.documentAttributes.getDocTitle())) {
            return this.documentAttributes.getDocTitle();
        }
        return Constants.DOCUMENT_TITLE;
    }

    @Override
    public CukedoctorConverter renderAttributes() {
        this.docBuilder.append(this.headerRenderer.renderDocumentHeader(this.documentAttributes, this.docBuilder.createPeerBuilder()));
        return this;
    }

    @Override
    public CukedoctorConverter addCustomPdfTheme() {
        if (Assert.notNull(this.documentAttributes) && this.documentAttributes.getBackend() != null && this.documentAttributes.getBackend().equalsIgnoreCase("pdf")) {
            String pdfThemeName = "cukedoctor-pdf.yml";
            List<String> files = FileUtil.findFiles(this.cukedoctorConfig.getCustomizationDir(), pdfThemeName, true);
            if (Assert.hasElements(files)) {
                String themePath = files.get(0);
                themePath = themePath.replaceAll("\\\\", "/");
                this.documentAttributes.pdfStyle(themePath);
            }
        }
        return this;
    }

    @Override
    public CukedoctorConverter addCustomCss() {
        return this;
    }

    @Override
    public CukedoctorConverter renderSummary() {
        this.docBuilder.textLine(this.summaryRenderer.renderSummary(this.features, this.docBuilder.createNestedBuilder()));
        return this;
    }

    @Override
    public CukedoctorConverter renderFeatures(List<Feature> features) {
        this.docBuilder.append(this.featureRenderer.renderFeatures(features, this.docBuilder.createNestedBuilder()));
        return this;
    }

    @Override
    public CukedoctorConverter renderFeatures() {
        return this.renderFeatures(this.features);
    }

    @Override
    public CukedoctorConverter setFilename(String filename) {
        if (filename == null) {
            filename = this.getDocumentationTitle();
        }
        if (!filename.contains(".")) {
            filename = filename + ".adoc";
        }
        if (!FileUtil.ADOC_FILE_EXTENSION.matcher(filename = filename.replaceAll(" ", "_")).matches()) {
            throw new RuntimeException("Invalid filename extension for file: " + filename + ". Valid formats are: ad, adoc, asciidoc and asc");
        }
        this.filename = filename;
        return this;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public CukedoctorConverter saveDocumentation() {
        FileUtil.saveFile(this.filename, this.renderDocumentation());
        return this;
    }
}

