/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.parser;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.util.FileUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureParser {
    private static final Logger log = LoggerFactory.getLogger(FeatureParser.class);

    public static List<Feature> parse(String json) {
        List features = null;
        try (InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(json), "UTF-8");){
            features = (List)new ObjectMapper().readValue((Reader)is, (TypeReference)new TypeReference<List<Feature>>(){});
            Iterator it = features.iterator();
            while (it.hasNext()) {
                Feature feature = (Feature)it.next();
                if (!feature.isCucumberFeature()) {
                    log.warn("json: {} is NOT a Cucumber feature result file and will be ignored", (Object)json);
                    it.remove();
                    continue;
                }
                feature.initScenarios();
                feature.processSteps();
            }
        }
        catch (FileNotFoundException e) {
            log.warn("Could not find json file: {}", (Object)json);
        }
        catch (JsonMappingException e) {
            log.warn("Could not map json file: {}", (Object)json);
        }
        catch (JsonParseException e) {
            log.warn("Could not parse json file: {}", (Object)json);
        }
        catch (IOException e) {
            log.warn("Could not read json file: {}", (Object)json);
        }
        return features;
    }

    public static List<Feature> parse(List<String> paths) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (String path : paths) {
            List<Feature> result = FeatureParser.parse(path);
            if (result == null) continue;
            features.addAll(result);
        }
        return features;
    }

    public static List<Feature> parse(String ... paths) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (String path : paths) {
            List<Feature> result = FeatureParser.parse(path);
            if (result == null) continue;
            features.addAll(result);
        }
        return features;
    }

    public static List<Feature> findAndParse(String basePath) {
        List<String> paths = FileUtil.findJsonFiles(basePath);
        return FeatureParser.parse(paths);
    }
}

