/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.renderer.CukedoctorExamplesRenderer;
import com.github.cukedoctor.renderer.CukedoctorStepsRenderer;
import com.github.cukedoctor.renderer.CukedoctorTagsRenderer;
import com.github.cukedoctor.spi.ExamplesRenderer;
import com.github.cukedoctor.spi.ScenarioRenderer;
import com.github.cukedoctor.spi.StepsRenderer;
import com.github.cukedoctor.spi.TagsRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.ServiceLoaderUtil;
import com.github.cukedoctor.util.StringUtil;
import java.util.List;

public class CukedoctorScenarioRenderer
extends AbstractBaseRenderer
implements ScenarioRenderer {
    TagsRenderer tagsRenderer;
    ExamplesRenderer examplesRenderer;
    StepsRenderer stepsRenderer;

    public CukedoctorScenarioRenderer() {
    }

    public CukedoctorScenarioRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
    }

    private void loadDependentRenderers() {
        this.tagsRenderer = new ServiceLoaderUtil<CukedoctorTagsRenderer>().initialise(TagsRenderer.class, CukedoctorTagsRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
        this.examplesRenderer = new ServiceLoaderUtil<CukedoctorExamplesRenderer>().initialise(ExamplesRenderer.class, CukedoctorExamplesRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
        this.stepsRenderer = new ServiceLoaderUtil<CukedoctorStepsRenderer>().initialise(StepsRenderer.class, CukedoctorStepsRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[0]);
    }

    @Override
    public String renderScenario(Scenario scenario, Feature feature) {
        this.loadDependentRenderers();
        this.docBuilder.clear();
        if (scenario.hasIgnoreDocsTag()) {
            return "";
        }
        if (scenario.isBackground() && feature.isBackgroundRendered()) {
            return "";
        }
        if (!feature.isBackgroundRendered() && scenario.isBackground()) {
            feature.setBackgroundRendered(true);
            StringBuilder backgroundTitle = new StringBuilder(scenario.getKeyword());
            if (!Status.passed.equals((Object)scenario.getStatus())) {
                backgroundTitle.append(" " + Status.getStatusIcon(Status.failed));
            }
            this.docBuilder.title(backgroundTitle.toString().replaceAll("\\\\", ""));
        }
        if (Assert.hasText(scenario.getName())) {
            StringBuilder scenarioTitle = new StringBuilder();
            if (this.cukedoctorConfig.isHideScenarioKeyword().booleanValue()) {
                scenarioTitle.append(scenario.getName());
            } else {
                scenarioTitle.append(scenario.getKeyword()).append(": ").append(scenario.getName());
            }
            if (Assert.notNull((Object)scenario.getStatus()) && !Status.passed.equals((Object)scenario.getStatus())) {
                scenarioTitle.append(" " + Status.getStatusIcon(Status.failed));
            }
            this.docBuilder.title(scenarioTitle.toString());
        }
        if (!this.cukedoctorConfig.isHideTags().booleanValue()) {
            this.docBuilder.append(this.renderScenarioTags(scenario, feature));
        }
        if (Assert.hasText(scenario.getDescription())) {
            this.docBuilder.textLine(StringUtil.trimAllLines(scenario.getDescription()).replaceAll("\\\\", "")).newLine();
        } else {
            this.docBuilder.textLine("").newLine();
        }
        if (scenario.hasExamples()) {
            this.docBuilder.append(this.renderScenarioExamples(scenario));
            return this.docBuilder.toString();
        }
        if (scenario.hasSteps()) {
            this.docBuilder.append(this.renderScenarioSteps(scenario.getSteps(), scenario, feature));
        }
        return this.docBuilder.toString();
    }

    private String renderScenarioSteps(List<Step> scenarioSteps, Scenario scenario, Feature feature) {
        return this.stepsRenderer.renderSteps(scenarioSteps, scenario, feature, this.docBuilder.createNestedBuilder());
    }

    private String renderScenarioExamples(Scenario scenario) {
        return this.examplesRenderer.renderScenarioExamples(scenario, this.docBuilder.createNestedBuilder());
    }

    private String renderScenarioTags(Scenario scenario, Feature feature) {
        return this.tagsRenderer.renderScenarioTags(feature, scenario, this.docBuilder.createPeerBuilder());
    }
}

