/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.model.Comment;
import com.github.cukedoctor.api.model.DocString;
import com.github.cukedoctor.api.model.Embedding;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Output;
import com.github.cukedoctor.api.model.Result;
import com.github.cukedoctor.api.model.Row;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.api.model.Step;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.spi.StepsRenderer;
import com.github.cukedoctor.util.Assert;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.Formatter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CukedoctorStepsRenderer
extends AbstractBaseRenderer
implements StepsRenderer {
    public CukedoctorStepsRenderer() {
    }

    public CukedoctorStepsRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
    }

    @Override
    public String renderSteps(List<Step> steps, Scenario scenario, Feature feature) {
        this.docBuilder.clear();
        this.docBuilder.textLine("==========");
        for (Step step : steps) {
            this.docBuilder.append(step.getKeyword(), "::", Constants.newLine());
            this.docBuilder.append(step.getName() + " ", Status.getStatusIcon(step.getStatus()));
            if (!this.cukedoctorConfig.isHideStepTime().booleanValue()) {
                this.docBuilder.append(this.renderStepTime(step.getResult()));
            }
            this.docBuilder.append(this.renderStepTable(step));
            if (Assert.notNull(step.getDocString()) && Assert.hasText(step.getDocString().getValue())) {
                if (step.getDocString().isDiscrete() || step.hasDiscreteComment() || this.isDiscrete(scenario) || this.isDiscrete(feature)) {
                    this.renderDiscreteSidebarBlock(step.getDocString());
                } else {
                    this.renderListingBlock(step.getDocString());
                }
            }
            if (step.getResult() != null && !Status.passed.equals((Object)step.getStatus()) && step.getResult().getErrorMessage() != null) {
                this.docBuilder.append(Constants.newLine(), "IMPORTANT: ", step.getResult().getErrorMessage(), Constants.newLine());
            }
            this.renderOutput(step);
            this.renderAttachments(step);
            this.enrichStep(step);
        }
        this.docBuilder.textLine("==========").newLine();
        return this.docBuilder.toString();
    }

    private boolean isDiscrete(Scenario scenario) {
        if (!scenario.hasTags()) {
            return false;
        }
        return this.isDiscrete(scenario.getTags());
    }

    private boolean isDiscrete(Feature feature) {
        if (!feature.hasTags()) {
            return false;
        }
        return this.isDiscrete(feature.getTags());
    }

    private boolean isDiscrete(Iterable<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.isDiscrete()) continue;
            return true;
        }
        return false;
    }

    void renderOutput(Step step) {
        if (step.hasOutput()) {
            this.docBuilder.textLine(Constants.Markup.listing());
            for (Output output : step.getOutput()) {
                this.docBuilder.textLine(output.getValue());
            }
            this.docBuilder.textLine(Constants.Markup.listing());
        }
    }

    private void renderAttachments(Step step) {
        if (!step.hasEmbeddings()) {
            return;
        }
        AtomicInteger notNamedCount = new AtomicInteger(1);
        for (Embedding attachment : step.getEmbeddings()) {
            if (!this.shouldRenderAttachment(attachment)) continue;
            this.renderAttachmentTitle(attachment, notNamedCount);
            this.renderAttachmentContent(attachment);
        }
    }

    private boolean shouldRenderAttachment(Embedding attachment) {
        return Assert.hasText(attachment.getMimeType()) && attachment.getMimeType().startsWith("text/");
    }

    private void renderAttachmentContent(Embedding attachment) {
        this.docBuilder.textLine("[%collapsible]");
        this.docBuilder.textLine(Constants.Markup.exampleBlock());
        if (Assert.hasText(attachment.getData())) {
            this.docBuilder.textLine(this.getAttachmentContent(attachment));
        }
        this.docBuilder.textLine(Constants.Markup.exampleBlock());
    }

    private String getAttachmentContent(Embedding attachment) {
        try {
            return new String(Base64.getDecoder().decode(attachment.getData()), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return attachment.getData();
        }
    }

    private void renderAttachmentTitle(Embedding attachment, AtomicInteger notNamedCount) {
        this.docBuilder.newLine();
        this.docBuilder.append(".");
        this.docBuilder.textLine(this.getAttachmentTitle(attachment, notNamedCount));
    }

    private String getAttachmentTitle(Embedding attachment, AtomicInteger notNamedCount) {
        if (Assert.hasText(attachment.getName())) {
            return attachment.getName();
        }
        return "Attachment " + notNamedCount.getAndIncrement();
    }

    private void renderListingBlock(DocString docString) {
        if (docString.getContentType() != null && !docString.getContentType().equals("")) {
            this.docBuilder.append("[source,", docString.getContentType(), "]", Constants.newLine());
        }
        this.docBuilder.append(Constants.Markup.listing(), Constants.newLine(), Constants.newLine());
        this.docBuilder.append(docString.getValue().replaceAll("\\n", Constants.newLine()));
        this.docBuilder.append(Constants.newLine(), Constants.newLine(), Constants.Markup.listing(), Constants.newLine());
    }

    private void renderDiscreteSidebarBlock(DocString docString) {
        this.docBuilder.append("******", Constants.newLine(), Constants.newLine());
        String[] lines = docString.getValue().replaceAll("\\*\\*\\*\\*", "*****").replaceAll(Constants.Markup.exampleBlock(), Constants.Markup.exampleBlock() + "=").split("\\n");
        boolean isListing = false;
        boolean isTable = false;
        for (String line : lines) {
            if (!isListing) {
                line = line.replaceAll("\r", "");
            }
            if (isListing) {
                if (line.contains("----")) {
                    isListing = false;
                }
                this.docBuilder.textLine(line);
                continue;
            }
            if (!isListing && line.contains("----")) {
                isListing = true;
                this.docBuilder.textLine(line);
                continue;
            }
            if (line.startsWith("<") && line.endsWith(">")) {
                this.docBuilder.textLine(line);
                continue;
            }
            if (line.startsWith("======")) {
                this.docBuilder.textLine(line);
                continue;
            }
            if (isTable) {
                this.docBuilder.textLine(line);
                if (!line.contains(Constants.Markup.table())) continue;
                isTable = false;
                continue;
            }
            if (line.contains(Constants.Markup.table())) {
                isTable = true;
            }
            this.docBuilder.textLine("[discrete]").textLine(line);
        }
        this.docBuilder.append(Constants.newLine(), Constants.newLine(), "******", Constants.newLine());
    }

    private void enrichStep(Step step) {
        if (step != null && step.hasComments()) {
            int numComments = step.getComments().size();
            for (Comment comment : step.getComments()) {
                if (Assert.hasText(comment.getValue()) && comment.getValue().contains("{") && comment.getValue().contains("}")) {
                    String line = comment.getValue();
                    if (comment.getValue().contains("[source") || line.contains("====") || line.contains(Constants.Markup.listing()) || line.startsWith("<") && line.endsWith(">")) {
                        this.docBuilder.textLine(line.replaceAll("\\n", Constants.newLine()).replaceAll("#\\{", "").replaceAll("# \\{", "").replaceAll("}", ""));
                    } else {
                        this.docBuilder.textLine(line.replaceAll("\\n", Constants.newLine()).replaceAll("#\\{", Constants.newLine()).replaceAll("# \\{", Constants.newLine()).replaceAll("}", ""));
                    }
                }
                if (step.getComments().indexOf(comment) != numComments - 1) continue;
                this.docBuilder.newLine();
            }
        }
    }

    String renderStepTime(Result result) {
        if (result == null || result.getDuration() == null) {
            return "";
        }
        return " [small right]#(" + Formatter.formatTime(result.getDuration()) + ")#";
    }

    String renderStepTable(Step step) {
        CukedoctorDocumentBuilder builder = CukedoctorDocumentBuilder.Factory.newInstance();
        builder.newLine();
        if (Assert.notEmpty(step.getRows())) {
            builder.newLine();
            builder.append("[cols=\"" + step.getRows()[0].getCells().length + "*\", options=\"header\"]").newLine();
            builder.textLine(Constants.Markup.table());
            Row header = step.getRows()[0];
            for (String col : header.getCells()) {
                builder.append(Constants.Markup.tableCol(), col).newLine();
            }
            for (int i = 1; i < step.getRows().length; ++i) {
                for (String cell : step.getRows()[i].getCells()) {
                    builder.append(Constants.Markup.tableCol(), cell).newLine();
                }
            }
            builder.textLine(Constants.Markup.table());
            builder.newLine();
        }
        return builder.toString();
    }
}

