/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.renderer;

import com.github.cukedoctor.api.ScenarioResults;
import com.github.cukedoctor.api.StepResults;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.ScenarioTotalizations;
import com.github.cukedoctor.api.model.Status;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.spi.SummaryRenderer;
import com.github.cukedoctor.util.Constants;
import com.github.cukedoctor.util.Formatter;
import java.util.List;

public class CukedoctorSummaryRenderer
extends AbstractBaseRenderer
implements SummaryRenderer {
    private ScenarioTotalizations scenarioTotalizationsCache;

    public CukedoctorSummaryRenderer() {
    }

    public CukedoctorSummaryRenderer(CukedoctorConfig cukedoctorConfig) {
        this.cukedoctorConfig = cukedoctorConfig;
    }

    @Override
    public String renderSummary(List<Feature> features) {
        this.docBuilder.clear();
        this.calculateTotalizations(features);
        this.docBuilder.textLine(Constants.Markup.H2(Constants.Markup.bold(this.i18n.getMessage("title.summary"))));
        this.docBuilder.append("[cols=\"12*^m\", options=\"header,footer\"]", Constants.newLine(), "|===", Constants.newLine() + "3+|" + this.i18n.getMessage("title.scenario") + "s 7+|" + this.i18n.getMessage("summary.steps") + " 2+|", this.i18n.getMessage("title.features"), ": ", features.size() + "", Constants.newLine(), Constants.newLine() + "|[green]#*", this.i18n.getMessage("result.passed"), "*#", Constants.newLine(), "|[red]#*", this.i18n.getMessage("result.failed"), "*#", Constants.newLine(), "|Total", Constants.newLine(), "|[green]#*", this.i18n.getMessage("result.passed"), "*#", Constants.newLine(), "|[red]#*", this.i18n.getMessage("result.failed"), "*#", Constants.newLine(), "|[purple]#*", this.i18n.getMessage("result.skipped"), "*#", Constants.newLine(), "|[maroon]#*", this.i18n.getMessage("result.pending"), "*#", Constants.newLine(), "|[yellow]#*", this.i18n.getMessage("result.undefined"), "*#", Constants.newLine(), "|[blue]#*", this.i18n.getMessage("result.missing"), "*#", Constants.newLine(), "|Total", Constants.newLine(), "|" + this.i18n.getMessage("summary.duration"), Constants.newLine(), "|Status").newLine();
        for (Feature feature : features) {
            this.docBuilder.append(Constants.newLine(), "12+^", Constants.Markup.tableCol(), "*<<", feature.getName().replaceAll(",", "").replaceAll(" ", "-"), ">>*", Constants.newLine());
            StepResults stepResults = feature.getStepResults();
            ScenarioResults scenarioResults = feature.getScenarioResults();
            this.docBuilder.append(Constants.Markup.tableCol(), scenarioResults.getNumberOfScenariosPassed(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), scenarioResults.getNumberOfScenariosFailed(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), scenarioResults.getNumberOfScenarios(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfPasses(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfFailures(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfSkipped(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfPending(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfUndefined(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfMissing(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getNumberOfSteps(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), stepResults.getTotalDurationAsString(), Constants.newLine());
            this.docBuilder.append(Constants.Markup.tableCol(), Status.getStatusColor(feature.getStatus()), Constants.newLine());
        }
        this.renderTotalsRow();
        this.docBuilder.textLine(Constants.Markup.table());
        return this.docBuilder.toString();
    }

    private void calculateTotalizations(List<Feature> features) {
        if (this.scenarioTotalizationsCache == null) {
            this.scenarioTotalizationsCache = new ScenarioTotalizations(features);
        }
    }

    private void renderTotalsRow() {
        this.docBuilder.append("12+^|*" + this.i18n.getMessage("summary.total") + "*", Constants.newLine()).append(Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalPassedScenarios(), Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalFailedScenarios()).append(Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalScenarios()).append(Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalPassedSteps(), Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalFailedSteps()).append(Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalSkippedSteps(), Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalPendingSteps()).append(Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalUndefinedSteps(), Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalMissingSteps()).append(Constants.Markup.tableCol(), this.scenarioTotalizationsCache.getTotalSteps(), " 2+", Constants.Markup.tableCol(), Formatter.formatTime(this.scenarioTotalizationsCache.getTotalDuration()));
        this.docBuilder.newLine();
    }
}

