/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public abstract class Constants {
    public static final String SKIP_DOCS = "@skipDocs";
    public static final String BASE_DIR = Files.exists(Paths.get("target", new String[0]), new LinkOption[0]) ? Paths.get("target", new String[0]).toString() : (Files.exists(Paths.get("bin", new String[0]), new LinkOption[0]) ? Paths.get("bin", new String[0]).toString() : Paths.get("", new String[0]).toString());
    public static final String STOP_WATCH = "cukedoctor.stopwatch";
    public static final String DISCRETE = "[discrete]";
    public static final String DOCUMENT_TITLE = System.getProperty("DOCUMENT_TITLE") == null ? "Documentation" : System.getProperty("DOCUMENT_TITLE");

    public static String newLine() {
        return System.getProperty("line.separator");
    }

    public static String home() {
        String homeDir = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        if (!homeDir.endsWith("/")) {
            homeDir = homeDir + "/";
        }
        if (Constants.isWindows() && homeDir.startsWith("/")) {
            homeDir = homeDir.substring(1);
        }
        return homeDir;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static <T> T getProp(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        return type.cast(System.getProperty(property));
    }

    public static Boolean getBooleanProperty(String property) {
        String value = System.getProperty(property);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(System.getProperty(property));
    }

    public static abstract class Attributes {
        private static String toAdocAttr(String attrName, Object attrValue) {
            if (attrValue == null || "".equals(attrValue.toString().trim())) {
                return "";
            }
            StringBuilder adocAttr = new StringBuilder();
            adocAttr.append(":");
            if (Boolean.class.isAssignableFrom(attrValue.getClass())) {
                boolean bool = Boolean.parseBoolean(attrValue.toString());
                if (!bool) {
                    adocAttr.append("!");
                }
                adocAttr.append(attrName).append(":");
            } else {
                adocAttr.append(attrName).append(":").append(" ").append(attrValue.toString());
            }
            return adocAttr.toString();
        }

        public static String toc(String value) {
            return Attributes.toAdocAttr(Name.TOC.name, value);
        }

        public static String tocLevels(String value) {
            return Attributes.toAdocAttr(Name.TOCLEVELS.name, value);
        }

        public static String icons(String value) {
            return Attributes.toAdocAttr(Name.ICONS.name, value);
        }

        public static String numbered(boolean numbered) {
            return Attributes.toAdocAttr(Name.NUMBERED.name, numbered);
        }

        public static String hardBreaks(boolean hardBreaks) {
            return Attributes.toAdocAttr(Name.HARDBREAKS.name, hardBreaks);
        }

        public static String linkcss(boolean linkcss) {
            return Attributes.toAdocAttr(Name.LINKCSS.name, linkcss);
        }

        public static String sectAnchors(boolean sectAnchors) {
            return Attributes.toAdocAttr(Name.SECTANCHORS.name, sectAnchors);
        }

        public static String sectLink(boolean sectLink) {
            return Attributes.toAdocAttr(Name.SECTLINK.name, sectLink);
        }

        public static String backend(String backend) {
            return Attributes.toAdocAttr(Name.BACKEND.name, backend);
        }

        public static String revNumber(String revNumber) {
            return Attributes.toAdocAttr(Name.REVNUMBER.name, revNumber);
        }

        public static String docTitle(String docTitle) {
            return Attributes.toAdocAttr(Name.DOCTITLE.name, docTitle);
        }

        public static String docType(String docType) {
            return Attributes.toAdocAttr(Name.DOCTYPE.name, docType);
        }

        public static String docInfo(boolean docInfo) {
            return Attributes.toAdocAttr(Name.DOCINFO.name, docInfo);
        }

        public static String sourceHighlighter(String sourceHighlighter) {
            return Attributes.toAdocAttr(Name.SOURCEHIGHLIGHTER.name, sourceHighlighter);
        }

        public static String pdfStyle(String pdfStyle) {
            return Attributes.toAdocAttr(Name.PDFSTYLE.name, pdfStyle);
        }

        public static String versionLabel(String versionLabel) {
            return Attributes.toAdocAttr(Name.VERSIONLABEL.name, versionLabel);
        }

        public static String chapterLabel(String chapterLabel) {
            return Attributes.toAdocAttr(Name.CHAPTERLABEL.name, chapterLabel);
        }

        public static String stem(String stem) {
            return Attributes.toAdocAttr(Name.STEM.name, stem);
        }

        public static String allowUriRead(boolean allowUriRead) {
            return Attributes.toAdocAttr(Name.ALLOWURIREAD.name, allowUriRead);
        }

        public static String dataUri(Boolean value) {
            return Attributes.toAdocAttr(Name.DATAURI.name, value);
        }

        public static enum Name {
            TOC("toc"),
            TOCLEVELS("toclevels"),
            ICONS("icons"),
            NUMBERED("numbered"),
            HARDBREAKS("hardbreaks"),
            LINKCSS("linkcss"),
            SECTANCHORS("sectanchors"),
            SECTLINK("sectlink"),
            BACKEND("backend"),
            REVNUMBER("revnumber"),
            DOCTITLE("doctitle"),
            DOCTYPE("doctype"),
            DOCINFO("docinfo"),
            SOURCEHIGHLIGHTER("source-highlighter"),
            PDFSTYLE("pdf-style"),
            VERSIONLABEL("version-label"),
            CHAPTERLABEL("chapter-label"),
            STEM("stem"),
            ALLOWURIREAD("allow-uri-read"),
            DATAURI("data-uri");

            final String name;

            private Name(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }
    }

    public static abstract class Markup {
        public static String bold(String value) {
            return "*" + value + "*";
        }

        public static String style(String style, String value) {
            return "[" + style + "]#" + value + "#";
        }

        public static String H1(String value) {
            return "= " + value;
        }

        public static String H2(String value) {
            return "== " + value;
        }

        public static String H3(String value) {
            return "=== " + value;
        }

        public static String H4(String value) {
            return "==== " + value;
        }

        public static String table() {
            return "|===";
        }

        public static String tableCol() {
            return "|";
        }

        public static String listing() {
            return "----";
        }

        public static String exampleBlock() {
            return "=====";
        }
    }
}

