/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.extension;

import java.text.DateFormat;
import java.util.Date;
import java.util.PropertyResourceBundle;
import java.util.logging.Logger;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Postprocessor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class CukedoctorFooterExtension
extends Postprocessor {
    private static final DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);

    public String process(Document document, String output) {
        if (document.isBasebackend("html") && System.getProperty("cukedoctor.disable.footer") == null) {
            String stopWatch = System.getProperty("cukedoctor.stopwatch");
            Double generationTimeInSeconds = new Double(0.0);
            String documentationDate = dateFormat.format(new Date());
            String cukedoctorVersion = "";
            try {
                PropertyResourceBundle bundle = new PropertyResourceBundle(CukedoctorFooterExtension.class.getResourceAsStream("/cukedoctor-extension.properties"));
                cukedoctorVersion = bundle.getString("cukedoctor.version");
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Could not find bundle cukedoctor-extension");
            }
            if (stopWatch != null && !"".equals(stopWatch)) {
                long begin = 0L;
                try {
                    begin = Long.parseLong(stopWatch);
                    generationTimeInSeconds = (double)(System.currentTimeMillis() - begin) / 1000.0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            org.jsoup.nodes.Document doc = Jsoup.parse((String)output, (String)"UTF-8");
            Element contentElement = doc.getElementById("footer");
            contentElement.attr("style", "color:gray;font-size:11px");
            contentElement.text("Generated by ").append("<a href=https://github.com/rmpestano/cukedoctor target=\"_blank\"> Cukedoctor " + cukedoctorVersion + "</a>");
            contentElement.append(" - " + documentationDate);
            contentElement.append("<span style=\"float:right;font-size:11px\"> Execution time: " + generationTimeInSeconds + " seconds</span>");
            return doc.html();
        }
        return output;
    }
}

