/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.extension;

import com.github.cukedoctor.extension.util.FileUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.asciidoctor.ast.Document;
import org.asciidoctor.extension.Postprocessor;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class CukedoctorStyleExtension
extends Postprocessor {
    private static final Logger LOG = Logger.getLogger(CukedoctorStyleExtension.class.getName());
    public static final String BASE_DIR = Files.exists(Paths.get("target", new String[0]), new LinkOption[0]) ? Paths.get("target", new String[0]).toString() : (Files.exists(Paths.get("bin", new String[0]), new LinkOption[0]) ? Paths.get("bin", new String[0]).toString() : Paths.get("", new String[0]).toString());
    public static final String CUKEDOCTOR_CUSTOMIZATION_DIR = CukedoctorStyleExtension.getProperty("CUKEDOCTOR_CUSTOMIZATION_DIR") == null ? BASE_DIR : CukedoctorStyleExtension.getProperty("CUKEDOCTOR_CUSTOMIZATION_DIR");

    public String process(Document document, String output) {
        if (document.basebackend("html")) {
            org.jsoup.nodes.Document doc = Jsoup.parse((String)output, (String)"UTF-8");
            if (System.getProperty("cukedoctor.disable.style") == null) {
                Element contentElement = doc.getElementById("footer");
                this.addFooterStyle(contentElement);
                this.addCukedoctorCss(doc);
            }
            return doc.html();
        }
        return output;
    }

    private void addFooterStyle(Element contentElement) {
        String styleClass = " <style>  \n\n#content:padding:0!important;\n.sidebarblock, .sectionbody, .content{\noverflow:auto!important;\n}\ndiv.sidebarblock {overflow-y:hidden;overflow-x:auto}\n body .exampleblock > .content{ background:#fff}";
        contentElement.after(styleClass);
    }

    private void addCukedoctorCss(org.jsoup.nodes.Document document) {
        List<String> files = FileUtil.findFiles(CUKEDOCTOR_CUSTOMIZATION_DIR, "cukedoctor.css", true);
        if (files != null && !files.isEmpty()) {
            String themePath = files.get(0);
            themePath = themePath.replaceAll("\\\\", "/");
            try {
                String customCss = IOUtils.toString((InputStream)new FileInputStream(themePath));
                Elements head = document.getElementsByTag("head");
                head.append(" <style> " + customCss + "</style>");
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Could not copy cukedoctor css from: " + themePath, e);
            }
        }
    }

    private static String getProperty(String property) {
        if (System.getProperty(property) == null) {
            return null;
        }
        return System.getProperty(property);
    }
}

