/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.mojo;

import com.github.cukedoctor.Cukedoctor;
import com.github.cukedoctor.api.CukedoctorConverter;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.config.GlobalConfig;
import com.github.cukedoctor.mojo.model.Format;
import com.github.cukedoctor.mojo.model.Toc;
import com.github.cukedoctor.parser.FeatureParser;
import com.github.cukedoctor.util.FileUtil;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.extension.ExtensionGroup;

@Mojo(name="execute", defaultPhase=LifecyclePhase.INSTALL)
public class CukedoctorMojo
extends AbstractMojo {
    @Parameter(defaultValue="documentation", required=false)
    String outputFileName;
    @Parameter(defaultValue="cukedoctor", required=false)
    String outputDir;
    @Parameter(required=false)
    String featuresDir;
    @Parameter(required=false)
    String introChapterDir;
    @Parameter(required=false)
    String documentTitle;
    @Parameter(defaultValue="html5", required=true)
    Format format;
    @Parameter(defaultValue="right", required=false)
    Toc toc;
    @Parameter(defaultValue="false", required=false)
    boolean numbered;
    @Parameter(defaultValue="false", required=false)
    boolean disableTheme;
    @Parameter(defaultValue="false", required=false)
    boolean disableFilter;
    @Parameter(defaultValue="false", required=false)
    boolean disableMinimizable;
    @Parameter(defaultValue="false", required=false)
    boolean disableFooter;
    @Parameter(defaultValue="Chapter", required=false)
    String chapterLabel;
    @Parameter(defaultValue="Version", required=false)
    String versionLabel;
    @Parameter(required=false)
    String docVersion;
    @Parameter(defaultValue="true", required=false)
    boolean hardBreaks;
    @Parameter(required=false)
    Boolean hideFeaturesSection;
    @Parameter(required=false)
    Boolean hideSummarySection;
    @Parameter(required=false)
    Boolean hideScenarioKeyword;
    @Parameter(required=false)
    Boolean hideStepTime;
    @Parameter(required=false)
    Boolean hideTags;
    @Parameter(required=false)
    String sourceHighlighter;
    @Parameter(required=false)
    Boolean allowUriRead;
    @Parameter(property="cukedoctor.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="stem", required=false)
    String stem;
    @Component
    MavenProject project;
    private String generatedFile = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping cukedoctor-maven-plugin");
            return;
        }
        String startDir = null;
        if (this.featuresDir != null) {
            startDir = this.featuresDir;
        }
        if (startDir == null || !new File(startDir).exists()) {
            String string = startDir = this.project.getBuild().getDirectory() != null ? new File(this.project.getBuild().getDirectory()).getAbsolutePath() : null;
            if (startDir == null || !new File(startDir).exists()) {
                startDir = this.project.getBasedir().getAbsolutePath();
            }
        }
        if (this.introChapterDir != null) {
            System.setProperty("INTRO_CHAPTER_DIR", this.introChapterDir);
        }
        if (this.hideFeaturesSection != null) {
            System.setProperty("HIDE_FEATURES_SECTION", Boolean.toString(this.hideFeaturesSection));
        }
        if (this.hideSummarySection != null) {
            System.setProperty("HIDE_SUMMARY_SECTION", Boolean.toString(this.hideSummarySection));
        }
        if (this.hideScenarioKeyword != null) {
            System.setProperty("HIDE_SCENARIO_KEYWORD", Boolean.toString(this.hideScenarioKeyword));
        }
        if (this.hideStepTime != null) {
            System.setProperty("HIDE_STEP_TIME", Boolean.toString(this.hideStepTime));
        }
        if (this.hideTags != null) {
            System.setProperty("HIDE_TAGS", Boolean.toString(this.hideTags));
        }
        this.getLog().info((CharSequence)("Searching cucumber features in path: " + startDir));
        List featuresFound = FeatureParser.findAndParse((String)startDir);
        if (featuresFound == null || featuresFound.isEmpty()) {
            this.getLog().warn((CharSequence)("No cucumber json files found in " + startDir));
            return;
        }
        this.getLog().info((CharSequence)("Generating living documentation for " + featuresFound.size() + " feature(s)..."));
        if (this.chapterLabel == null) {
            this.chapterLabel = "Chapter";
        }
        if (this.versionLabel == null) {
            this.versionLabel = "Version";
        }
        this.configExtensions();
        DocumentAttributes documentAttributes = GlobalConfig.newInstance().getDocumentAttributes().backend(this.format.name().toLowerCase()).toc(this.toc.name().toLowerCase()).revNumber(this.docVersion).hardBreaks(this.hardBreaks).numbered(this.numbered).chapterLabel(this.chapterLabel).versionLabel(this.versionLabel).stem(this.stem);
        if (this.allowUriRead != null) {
            documentAttributes.allowUriRead(this.allowUriRead.booleanValue());
        }
        if (this.documentTitle == null) {
            this.documentTitle = "Living Documentation";
        }
        if (this.sourceHighlighter != null) {
            documentAttributes.sourceHighlighter(this.sourceHighlighter);
        }
        documentAttributes.docTitle(this.documentTitle);
        CukedoctorConverter converter = Cukedoctor.instance((List)featuresFound, (DocumentAttributes)documentAttributes);
        String targetFile = this.outputFileName.contains(".") ? this.outputFileName.substring(0, this.outputFileName.lastIndexOf(".")) + ".adoc" : this.outputFileName + ".adoc";
        String targetDir = this.getDocumentationDir();
        String pathToSave = targetDir + targetFile;
        converter.setFilename(pathToSave);
        this.generatedFile = converter.renderDocumentation();
        File adocFile = FileUtil.saveFile((String)pathToSave, (String)this.generatedFile);
        Asciidoctor asciidoctor = Asciidoctor.Factory.create();
        asciidoctor.requireLibrary(new String[]{"asciidoctor-diagram"});
        if (this.format.equals((Object)Format.all)) {
            documentAttributes.backend(Format.html5.name().toLowerCase());
            this.generateDocumentation(documentAttributes, adocFile, asciidoctor);
            documentAttributes = documentAttributes.backend(Format.pdf.name());
            converter = Cukedoctor.instance((List)featuresFound, (DocumentAttributes)documentAttributes);
            converter.setFilename(pathToSave);
            this.generatedFile = converter.renderDocumentation();
            adocFile = FileUtil.saveFile((String)pathToSave, (String)this.generatedFile);
            this.generateDocumentation(documentAttributes, adocFile, asciidoctor);
        } else {
            this.generateDocumentation(documentAttributes, adocFile, asciidoctor);
        }
        asciidoctor.shutdown();
    }

    private void configExtensions() {
        if (this.disableFilter) {
            System.setProperty("cukedoctor.disable.filter", "disabled");
        } else {
            System.clearProperty("cukedoctor.disable.filter");
        }
        if (this.disableMinimizable) {
            System.setProperty("cukedoctor.disable.minmax", "disabled");
        } else {
            System.clearProperty("cukedoctor.disable.minmax");
        }
        if (this.disableTheme) {
            System.setProperty("cukedoctor.disable.theme", "disabled");
        } else {
            System.clearProperty("cukedoctor.disable.theme");
        }
        if (this.disableFooter) {
            System.setProperty("cukedoctor.disable.footer", "disabled");
        } else {
            System.clearProperty("cukedoctor.disable.footer");
        }
    }

    private void generateDocumentation(DocumentAttributes documentAttributes, File adocFile, Asciidoctor asciidoctor) {
        OptionsBuilder ob = OptionsBuilder.options().safe(SafeMode.UNSAFE).backend(documentAttributes.getBackend()).attributes(documentAttributes.toMap());
        this.getLog().info((CharSequence)("Document attributes:\n" + documentAttributes.toMap()));
        ExtensionGroup cukedoctorExtensionGroup = asciidoctor.createGroup("com.github.cukedoctor");
        if ("pdf".equals(documentAttributes.getBackend())) {
            cukedoctorExtensionGroup.unregister();
            FileUtil.removeFile((String)(adocFile.getParent() + "/" + this.outputFileName + "-theme.yml"));
        }
        asciidoctor.convertFile(adocFile, ob);
        this.getLog().info((CharSequence)("Generated documentation at: " + adocFile.getParent()));
    }

    String getDocumentationDir() {
        String baseDir = this.project.getBuild().getDirectory();
        if (baseDir == null || new File(baseDir).exists()) {
            baseDir = this.project.getBasedir().getAbsolutePath();
            if (!new File(baseDir = baseDir + "/target").exists()) {
                baseDir = this.project.getBasedir().getAbsolutePath();
            }
        }
        if (!baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        if (this.outputDir == null) {
            this.outputDir = "cukedoctor/";
        }
        if (!this.outputDir.endsWith("/")) {
            this.outputDir = this.outputDir + "/";
        }
        return baseDir + this.outputDir;
    }

    public String getGeneratedFile() {
        return this.generatedFile;
    }
}

