/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.sectionlayout;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.api.model.Scenario;
import com.github.cukedoctor.api.model.Tag;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.sectionlayout.FeatureSection;
import com.github.cukedoctor.sectionlayout.Section;
import com.github.cukedoctor.util.builder.FeatureBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class BasicSection
implements Section {
    private final Map<String, Section> sectionsByGroup = new HashMap<String, Section>();
    private final List<Section> grouplessFeatures = new LinkedList<Section>();
    private final String id;
    private final String style;
    private final String groupingTagPattern;
    private int order = Integer.MAX_VALUE;
    private Section root;

    public BasicSection(String id) {
        this(id, null);
    }

    public BasicSection(String id, String style) {
        this(id, style, null);
    }

    public BasicSection(String id, String style, String groupingTagPattern) {
        this.id = id;
        this.style = style;
        this.groupingTagPattern = groupingTagPattern;
    }

    @Override
    public Section addFeature(Feature feature) {
        Optional<String> groupId = this.getGroupId(feature);
        if (groupId.isPresent()) {
            this.addToGroup(feature, groupId.get());
        } else if (this.hadRootScenario(feature)) {
            this.addAsRoot(feature);
        } else {
            this.addToGroupless(feature);
        }
        this.updateOrder(feature);
        return this;
    }

    private Optional<String> getGroupId(Feature feature) {
        return this.groupingTagPattern == null ? Optional.empty() : feature.extractTag(this.groupingTagPattern);
    }

    private void addToGroup(Feature feature, String groupId) {
        this.getGroupSection(groupId).addFeature(feature);
    }

    private Section getGroupSection(String groupId) {
        if (this.sectionsByGroup.containsKey(groupId)) {
            return this.sectionsByGroup.get(groupId);
        }
        BasicSection newGroup = new BasicSection(groupId);
        this.sectionsByGroup.put(groupId, newGroup);
        return newGroup;
    }

    private boolean hadRootScenario(Feature feature) {
        if (!feature.hasScenarios()) {
            return false;
        }
        for (Scenario scenario : feature.getScenarios()) {
            if (!scenario.getName().equals("Root")) continue;
            this.addSkipDocsTag(scenario);
            return true;
        }
        return false;
    }

    private void addSkipDocsTag(Scenario scenario) {
        if (scenario.hasTags()) {
            scenario.getTags().add(this.createSkipDocsTag());
            return;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>(1);
        tags.add(this.createSkipDocsTag());
        scenario.setTags(tags);
    }

    private Tag createSkipDocsTag() {
        return new Tag("@skipDocs");
    }

    private void addAsRoot(Feature feature) {
        this.root = new FeatureSection(feature);
    }

    private void addToGroupless(Feature feature) {
        this.grouplessFeatures.add(new FeatureSection(feature));
    }

    private void updateOrder(Feature feature) {
        this.order = Math.min(this.order, feature.getOrder());
    }

    @Override
    public String render(CukedoctorDocumentBuilder docBuilder, I18nLoader i18n, DocumentAttributes documentAttributes, CukedoctorConfig config) {
        if (!this.hasRoot() && this.sectionsByGroup.isEmpty() && this.grouplessFeatures.isEmpty()) {
            return "";
        }
        this.renderName(docBuilder, i18n, documentAttributes, config);
        this.renderChildren(docBuilder, i18n, documentAttributes, config);
        return docBuilder.toString();
    }

    private boolean hasRoot() {
        return this.root != null;
    }

    protected boolean shouldRenderSectionName(CukedoctorConfig config) {
        return true;
    }

    private void renderName(CukedoctorDocumentBuilder docBuilder, I18nLoader i18n, DocumentAttributes documentAttributes, CukedoctorConfig config) {
        if (!this.shouldRenderSectionName(config)) {
            return;
        }
        this.renderStyle(docBuilder);
        this.renderTitle(docBuilder, i18n, documentAttributes, config);
    }

    private void renderStyle(CukedoctorDocumentBuilder docBuilder) {
        if (this.style != null) {
            docBuilder.textLine("[" + this.style + "]");
        }
    }

    private void renderTitle(CukedoctorDocumentBuilder docBuilder, I18nLoader i18n, DocumentAttributes documentAttributes, CukedoctorConfig config) {
        Section titleSection = this.getTitleSection(i18n);
        docBuilder.append(new Object[]{titleSection.render(docBuilder.createPeerBuilder(), i18n, documentAttributes, config)}).nestTitle();
    }

    private Section getTitleSection(I18nLoader i18n) {
        if (this.hasRoot()) {
            return this.root;
        }
        String name = this.getName(i18n);
        return new FeatureSection(FeatureBuilder.instance().name(name).build());
    }

    protected String getName(I18nLoader i18n) {
        return this.id;
    }

    private void renderChildren(CukedoctorDocumentBuilder docBuilder, I18nLoader i18n, DocumentAttributes documentAttributes, CukedoctorConfig config) {
        this.getChildren().forEach(child -> docBuilder.append(new Object[]{child.render(docBuilder.createPeerBuilder(), i18n, documentAttributes, config)}));
    }

    private Stream<Section> getChildren() {
        return Stream.concat(this.sectionsByGroup.values().stream(), this.grouplessFeatures.stream()).sorted();
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public Stream<Feature> getFeatures() {
        return Stream.concat(this.hasRoot() ? this.root.getFeatures() : Stream.empty(), this.getChildren().flatMap(Section::getFeatures));
    }
}

