/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.sectionlayout;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.sectionlayout.BasicSection;
import com.github.cukedoctor.sectionlayout.BuiltInFeaturesSection;
import com.github.cukedoctor.sectionlayout.Section;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class DocumentSection
implements Section {
    private final BuiltInFeaturesSection featuresSection = new BuiltInFeaturesSection(){

        @Override
        public int getOrder() {
            return 2;
        }
    };
    private final Map<String, Collection<Feature>> featuresBySectionId = new HashMap<String, Collection<Feature>>();
    private final Section glossary = new BasicSection("Glossary", "glossary", null);
    private final Section bibliography = new BasicSection("Bibliography", "bibliography", null);
    private final Section index = new BasicSection("Index", "index", null);
    private final Set<String> appendixIds = new HashSet<String>();

    public DocumentSection() {
    }

    public DocumentSection(Iterable<Feature> features) {
        for (Feature feature : features) {
            this.addFeature(feature);
        }
    }

    @Override
    public Section addFeature(Feature feature) {
        if (feature.hasIgnoreDocsTag()) {
            return this;
        }
        if (this.isGlossary(feature)) {
            this.glossary.addFeature(feature);
            return this;
        }
        if (this.isBibliography(feature)) {
            this.bibliography.addFeature(feature);
            return this;
        }
        if (this.isIndex(feature)) {
            this.index.addFeature(feature);
            return this;
        }
        Optional sectionId = feature.extractTag("@section-");
        if (!sectionId.isPresent()) {
            this.featuresSection.addFeature(feature);
            return this;
        }
        this.addFeatureForSection(feature, (String)sectionId.get());
        if (feature.hasTag("@appendix")) {
            this.appendixIds.add((String)sectionId.get());
        }
        return this;
    }

    private boolean isGlossary(Feature feature) {
        return feature.hasTag("@glossary");
    }

    private boolean isBibliography(Feature feature) {
        return feature.hasTag("@bibliography");
    }

    private boolean isIndex(Feature feature) {
        return feature.hasTag("@index");
    }

    private void addFeatureForSection(Feature feature, String sectionId) {
        if (this.featuresBySectionId.containsKey(sectionId)) {
            this.featuresBySectionId.get(sectionId).add(feature);
            return;
        }
        LinkedList<Feature> features = new LinkedList<Feature>();
        features.add(feature);
        this.featuresBySectionId.put(sectionId, features);
    }

    @Override
    public String render(CukedoctorDocumentBuilder docBuilder, I18nLoader i18n, DocumentAttributes documentAttributes, CukedoctorConfig config) {
        this.buildDocument().forEach(section -> docBuilder.append(new Object[]{section.render(docBuilder.createPeerBuilder(), i18n, documentAttributes, config)}));
        return docBuilder.toString();
    }

    private Stream<Section> buildDocument() {
        LinkedList foreSections = new LinkedList();
        LinkedList appendices = new LinkedList();
        this.featuresBySectionId.forEach((sectionId, features) -> {
            if (this.appendixIds.contains(sectionId)) {
                appendices.add(new BasicSection((String)sectionId, "appendix", "@subsection-").addFeatures((Iterable<Feature>)features));
                return;
            }
            foreSections.add(new BasicSection((String)sectionId, null, "@subsection-").addFeatures((Iterable<Feature>)features));
        });
        return Stream.concat(foreSections.stream().sorted(), Stream.concat(Stream.of(this.featuresSection), Stream.concat(appendices.stream().sorted(), Stream.concat(Stream.of(this.glossary), Stream.concat(Stream.of(this.bibliography), Stream.of(this.index))))));
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Stream<Feature> getFeatures() {
        return this.buildDocument().flatMap(Section::getFeatures);
    }
}

