/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.sectionlayout;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.config.CukedoctorConfig;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.sectionlayout.NoSideBarBlockFeatureRenderer;
import com.github.cukedoctor.sectionlayout.Section;
import com.github.cukedoctor.sectionlayout.SectionFeatureRenderer;
import com.github.cukedoctor.spi.FeatureRenderer;
import com.github.cukedoctor.util.ServiceLoaderUtil;
import java.util.function.Function;
import java.util.stream.Stream;

public class FeatureSection
implements Section {
    private static final Function<CukedoctorConfig, FeatureRenderer> featureRenderer = config -> (FeatureRenderer)new ServiceLoaderUtil().load(FeatureRenderer.class, NoSideBarBlockFeatureRenderer.class, config, new Class[]{SectionFeatureRenderer.class});
    private final Feature feature;

    public FeatureSection(Feature feature) {
        this.feature = feature;
    }

    @Override
    public Section addFeature(Feature feature) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String render(CukedoctorDocumentBuilder docBuilder, I18nLoader i18n, DocumentAttributes documentAttributes, CukedoctorConfig config) {
        FeatureRenderer renderer = featureRenderer.apply(config);
        renderer.setI18n(i18n);
        renderer.setDocumentAttributes(documentAttributes);
        return renderer.renderFeature(this.feature, docBuilder);
    }

    @Override
    public int getOrder() {
        return this.feature.getOrder();
    }

    @Override
    public Stream<Feature> getFeatures() {
        return Stream.of(this.feature);
    }
}

