/*
 * Decompiled with CFR 0.152.
 */
package com.github.cukedoctor.sectionlayout;

import com.github.cukedoctor.api.CukedoctorDocumentBuilder;
import com.github.cukedoctor.api.DocumentAttributes;
import com.github.cukedoctor.api.model.Feature;
import com.github.cukedoctor.i18n.I18nLoader;
import com.github.cukedoctor.renderer.AbstractBaseRenderer;
import com.github.cukedoctor.renderer.CukedoctorSummaryRenderer;
import com.github.cukedoctor.sectionlayout.DocumentSection;
import com.github.cukedoctor.spi.SummaryRenderer;
import com.github.cukedoctor.util.ServiceLoaderUtil;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SectionSummaryRenderer
extends AbstractBaseRenderer
implements SummaryRenderer {
    private final ServiceLoaderUtil<SummaryRenderer> loader;
    private Supplier<SummaryRenderer> renderer;

    public SectionSummaryRenderer() {
        this((ServiceLoaderUtil<SummaryRenderer>)new ServiceLoaderUtil());
    }

    public SectionSummaryRenderer(ServiceLoaderUtil<SummaryRenderer> loader) {
        this.loader = loader;
        this.renderer = () -> {
            SummaryRenderer val = (SummaryRenderer)loader.initialise(SummaryRenderer.class, CukedoctorSummaryRenderer.class, this.i18n, this.documentAttributes, this.cukedoctorConfig, new Class[]{SectionSummaryRenderer.class});
            this.renderer = () -> val;
            return val;
        };
    }

    public String renderSummary(List<Feature> features) {
        return this.renderer.get().renderSummary(this.getSortedFeatures(features), this.docBuilder);
    }

    private List<Feature> getSortedFeatures(List<Feature> features) {
        return new DocumentSection(features).getFeatures().collect(Collectors.toList());
    }

    public void setI18n(I18nLoader i18n) {
        super.setI18n(i18n);
        this.renderer.get().setI18n(i18n);
    }

    public void setDocumentBuilder(CukedoctorDocumentBuilder documentBuilder) {
        super.setDocumentBuilder(documentBuilder);
        this.renderer.get().setDocumentBuilder(documentBuilder);
    }

    public void setDocumentAttributes(DocumentAttributes documentAttributes) {
        super.setDocumentAttributes(documentAttributes);
        this.renderer.get().setDocumentAttributes(documentAttributes);
    }
}

