/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.config.RgxGenOption;
import com.github.curiousoddman.rgxgen.config.RgxGenProperties;
import com.github.curiousoddman.rgxgen.model.GroupType;
import com.github.curiousoddman.rgxgen.model.MatchType;
import com.github.curiousoddman.rgxgen.model.RgxGenCharsDefinition;
import com.github.curiousoddman.rgxgen.model.SymbolRange;
import com.github.curiousoddman.rgxgen.model.UnicodeCategory;
import com.github.curiousoddman.rgxgen.model.WhitespaceChar;
import com.github.curiousoddman.rgxgen.nodes.Choice;
import com.github.curiousoddman.rgxgen.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.nodes.Group;
import com.github.curiousoddman.rgxgen.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.nodes.Node;
import com.github.curiousoddman.rgxgen.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.nodes.Repeat;
import com.github.curiousoddman.rgxgen.nodes.Sequence;
import com.github.curiousoddman.rgxgen.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import com.github.curiousoddman.rgxgen.parsing.dflt.CharIterator;
import com.github.curiousoddman.rgxgen.parsing.dflt.ConstantsProvider;
import com.github.curiousoddman.rgxgen.parsing.dflt.PatternDoesNotMatchAnythingException;
import com.github.curiousoddman.rgxgen.parsing.dflt.RgxGenParseException;
import com.github.curiousoddman.rgxgen.parsing.dflt.TokenNotQuantifiableException;
import com.github.curiousoddman.rgxgen.util.chars.CharList;
import com.github.curiousoddman.rgxgen.util.chars.CharListCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultTreeBuilder
implements NodeTreeBuilder {
    private final CharIterator aCharIterator;
    private final Map<Node, Integer> aNodesStartPos = new IdentityHashMap<Node, Integer>();
    private final RgxGenProperties properties;
    private Node aNode;
    private int aNextGroupIndex = 1;

    public DefaultTreeBuilder(String expr, RgxGenProperties properties) {
        this.aCharIterator = new CharIterator(expr);
        this.properties = properties;
    }

    private void sbToFinal(StringBuilder sb, Collection<Node> nodes) {
        if (sb.length() != 0) {
            FinalSymbol finalSymbol = new FinalSymbol(sb.toString());
            this.aNodesStartPos.put(finalSymbol, this.aCharIterator.prevPos() - finalSymbol.getValue().length());
            nodes.add(finalSymbol);
            sb.delete(0, Integer.MAX_VALUE);
        }
    }

    private GroupType processGroupType() {
        GroupType groupType;
        int skip = 2;
        if (this.aCharIterator.peek() == '?') {
            char pos2char = this.aCharIterator.peek(1);
            switch (pos2char) {
                case '<': {
                    skip = 3;
                    char pos3char = this.aCharIterator.peek(2);
                    if (pos3char == '!') {
                        groupType = GroupType.NEGATIVE_LOOKBEHIND;
                        break;
                    }
                    if (pos3char == '=') {
                        groupType = GroupType.POSITIVE_LOOKBEHIND;
                        break;
                    }
                    this.aCharIterator.skip(skip);
                    throw new RgxGenParseException("Unexpected symbol in pattern: " + this.aCharIterator.context());
                }
                case '=': {
                    groupType = GroupType.POSITIVE_LOOKAHEAD;
                    break;
                }
                case ':': {
                    groupType = GroupType.NON_CAPTURE_GROUP;
                    break;
                }
                case '!': {
                    groupType = GroupType.NEGATIVE_LOOKAHEAD;
                    break;
                }
                default: {
                    this.aCharIterator.skip(skip);
                    throw new RgxGenParseException("Unexpected symbol in pattern: " + this.aCharIterator.context());
                }
            }
        } else {
            return GroupType.CAPTURE_GROUP;
        }
        this.aCharIterator.skip(skip);
        return groupType;
    }

    private Node handleGroupEndCharacter(int startPos, StringBuilder sb, List<Node> nodes, boolean isChoice, List<Node> choices, Integer captureGroupIndex, GroupType groupType) {
        if (sb.length() == 0 && nodes.isEmpty()) {
            FinalSymbol finalSymbol = new FinalSymbol("");
            this.aNodesStartPos.put(finalSymbol, startPos);
            nodes.add(finalSymbol);
        } else {
            this.sbToFinal(sb, nodes);
        }
        if (isChoice) {
            choices.add(this.sequenceOrNot(startPos, nodes, choices, false, null));
            nodes.clear();
        }
        Node node = this.sequenceOrNot(startPos, nodes, choices, isChoice, captureGroupIndex);
        if (groupType.isNegative()) {
            return new NotSymbol(node.getPattern(), node);
        }
        return node;
    }

    private Integer getGroupIndexIfCapture(GroupType currentGroupType) {
        if (currentGroupType == GroupType.CAPTURE_GROUP) {
            return this.aNextGroupIndex++;
        }
        return null;
    }

    private static void assertCorrectCharacter(char currentChar) {
        if (currentChar != '^' && currentChar != '$') {
            throw new RgxGenParseException("This method should not be called for character '" + currentChar + "'. Please inform developers.");
        }
    }

    private void verifyStartEndMarkerConsistency(char currentChar) {
        String errorText;
        DefaultTreeBuilder.assertCorrectCharacter(currentChar);
        char charAtPos = this.aCharIterator.peek(currentChar == '^' ? -2 : 0);
        switch (charAtPos) {
            case '\u0000': 
            case '\n': 
            case '\r': 
            case '*': 
            case '+': 
            case '?': 
            case '{': 
            case '|': {
                return;
            }
            case '$': 
            case '^': {
                errorText = "Start and end of line markers cannot be put together.";
                break;
            }
            case '(': {
                if (currentChar == '$') {
                    errorText = "After dollar only new line is allowed!";
                    break;
                }
                return;
            }
            case ')': {
                if (currentChar == '^') {
                    errorText = "Before caret only new line is allowed!";
                    break;
                }
                return;
            }
            default: {
                errorText = currentChar == '^' ? "Before caret only new line is allowed!" : "After dollar only new line is allowed!";
            }
        }
        throw new PatternDoesNotMatchAnythingException(errorText + this.aCharIterator.context());
    }

    private Node parseGroup(int groupStartPos, GroupType currentGroupType) {
        Integer captureGroupIndex = this.getGroupIndexIfCapture(currentGroupType);
        int remainingLength = this.aCharIterator.remaining();
        ArrayList<Node> choices = new ArrayList<Node>(remainingLength);
        ArrayList<Node> nodes = new ArrayList<Node>(remainingLength);
        StringBuilder sb = new StringBuilder(remainingLength);
        boolean isChoice = false;
        int choicesStartPos = groupStartPos;
        block10: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next();
            switch (c) {
                case '$': 
                case '^': {
                    this.verifyStartEndMarkerConsistency(c);
                    continue block10;
                }
                case '[': {
                    this.sbToFinal(sb, nodes);
                    nodes.add(this.handleSquareBrackets());
                    continue block10;
                }
                case '(': {
                    this.sbToFinal(sb, nodes);
                    int intGroupStartPos = this.aCharIterator.prevPos();
                    GroupType groupType = this.processGroupType();
                    nodes.add(this.parseGroup(intGroupStartPos, groupType));
                    continue block10;
                }
                case '|': {
                    choicesStartPos = this.handlePipeCharacter(choices, nodes, sb, choicesStartPos);
                    isChoice = true;
                    continue block10;
                }
                case ')': {
                    return this.handleGroupEndCharacter(groupStartPos, sb, nodes, isChoice, choices, captureGroupIndex, currentGroupType);
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    this.handleRepeatCharacter(nodes, sb, c);
                    continue block10;
                }
                case '.': {
                    this.handleAnySymbolCharacter(nodes, sb);
                    continue block10;
                }
                case '\\': {
                    this.handleEscapedCharacter(sb, nodes, true);
                    continue block10;
                }
            }
            sb.append(c);
        }
        return this.handleGroupEndCharacter(groupStartPos, sb, nodes, isChoice, choices, captureGroupIndex, currentGroupType);
    }

    private void handleAnySymbolCharacter(Collection<Node> nodes, StringBuilder sb) {
        this.sbToFinal(sb, nodes);
        SymbolSet symbolSet = SymbolSet.ofDotPattern(this.properties);
        this.aNodesStartPos.put(symbolSet, this.aCharIterator.prevPos());
        nodes.add(symbolSet);
    }

    private int handlePipeCharacter(List<Node> choices, List<Node> nodes, StringBuilder sb, int choicesStartPos) {
        if (sb.length() == 0 && nodes.isEmpty()) {
            FinalSymbol finalSymbol = new FinalSymbol("");
            this.aNodesStartPos.put(finalSymbol, this.aCharIterator.prevPos() + 1);
            choices.add(finalSymbol);
        } else {
            this.sbToFinal(sb, nodes);
            choices.add(this.sequenceOrNot(choicesStartPos, nodes, choices, false, null));
            choicesStartPos = this.aCharIterator.prevPos() + 1;
            nodes.clear();
        }
        return choicesStartPos;
    }

    private void handleRepeatCharacter(List<Node> nodes, StringBuilder sb, char c) {
        Node repeatNode;
        if (sb.length() == 0) {
            if (nodes.isEmpty()) {
                char previousChar = this.aCharIterator.peek(-2);
                if (previousChar == '^' || previousChar == '$') {
                    throw new TokenNotQuantifiableException(previousChar + " at " + this.aCharIterator.context());
                }
                throw new RgxGenParseException("Cannot repeat nothing at" + this.aCharIterator.context());
            }
            repeatNode = nodes.remove(nodes.size() - 1);
        } else {
            char charToRepeat = sb.charAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            this.sbToFinal(sb, nodes);
            repeatNode = new FinalSymbol(String.valueOf(charToRepeat));
            this.aNodesStartPos.put(repeatNode, this.aCharIterator.prevPos() - 1);
        }
        nodes.add(this.handleRepeat(c, repeatNode));
    }

    private int parseHexadecimal() {
        String hexValue;
        char c = this.aCharIterator.peek();
        if (c == '{') {
            this.aCharIterator.skip();
            hexValue = this.aCharIterator.nextUntil('}');
        } else {
            hexValue = this.aCharIterator.next(2);
        }
        return Integer.parseInt(hexValue, 16);
    }

    private int parseUnicode() {
        String hexValue = this.aCharIterator.next(4);
        return Integer.parseInt(hexValue, 16);
    }

    private void handleGroupReference(boolean groupRefAllowed, Collection<Node> nodes, char firstCharacter) {
        if (!groupRefAllowed) {
            throw new RgxGenParseException("Group ref is not expected here. " + this.aCharIterator.context());
        }
        int startPos = this.aCharIterator.prevPos() - 1;
        String digitsSubstring = this.aCharIterator.takeWhile(Character::isDigit);
        String groupNumber = firstCharacter + digitsSubstring;
        GroupRef groupRef = new GroupRef("\\" + groupNumber, Integer.parseInt(groupNumber));
        this.aNodesStartPos.put(groupRef, startPos);
        nodes.add(groupRef);
    }

    private void handleEscapedCharacter(StringBuilder sb, Collection<Node> nodes, boolean groupRefAllowed) {
        char c = this.aCharIterator.next();
        Node createdNode = null;
        int nodeStartOffset = this.aCharIterator.prevPos() - 1;
        switch (c) {
            case 'D': 
            case 'd': {
                this.sbToFinal(sb, nodes);
                createdNode = SymbolSet.ofAsciiRanges("\\" + c, Collections.singletonList(ConstantsProvider.ASCII_DIGITS), DefaultTreeBuilder.getMatchType(c, 'd'));
                break;
            }
            case 'S': 
            case 's': {
                this.sbToFinal(sb, nodes);
                List<WhitespaceChar> whitespaceChars = RgxGenOption.WHITESPACE_DEFINITION.getFromProperties(this.properties);
                CharList whitespaceCharsList = whitespaceChars.stream().map(WhitespaceChar::get).collect(new CharListCollector());
                createdNode = SymbolSet.ofAscii("\\" + c, RgxGenCharsDefinition.of(whitespaceCharsList), RgxGenCharsDefinition.of(ConstantsProvider.getAsciiWhitespaces()), DefaultTreeBuilder.getMatchType(c, 's'));
                break;
            }
            case 'W': 
            case 'w': {
                this.sbToFinal(sb, nodes);
                createdNode = SymbolSet.ofAscii("\\" + c, ConstantsProvider.getAsciiWordCharRanges(), CharList.charList('_'), DefaultTreeBuilder.getMatchType(c, 'w'));
                break;
            }
            case 'P': 
            case 'p': {
                this.sbToFinal(sb, nodes);
                createdNode = this.createUnicodeSymbolSetNode(c, DefaultTreeBuilder.getMatchType(c, 'p'));
                break;
            }
            case 'x': {
                sb.append((char)this.parseHexadecimal());
                break;
            }
            case 'u': {
                sb.append((char)this.parseUnicode());
                break;
            }
            case 'Q': {
                sb.append(this.aCharIterator.nextUntil("\\E"));
                break;
            }
            case 'E': {
                break;
            }
            case 'B': 
            case 'b': {
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.sbToFinal(sb, nodes);
                this.handleGroupReference(groupRefAllowed, nodes, c);
                break;
            }
            default: {
                sb.append(c);
            }
        }
        if (createdNode != null) {
            this.aNodesStartPos.put(createdNode, nodeStartOffset);
            nodes.add(createdNode);
        }
    }

    private Node createUnicodeSymbolSetNode(char c, MatchType matchType) {
        String characterClassKey = this.getCharacterClassKey();
        UnicodeCategory unicodeCategory = UnicodeCategory.ALL_CATEGORIES.get(characterClassKey);
        String pattern = "\\" + c + "{" + characterClassKey + "}";
        return SymbolSet.ofUnicodeCharacterClass(pattern, unicodeCategory, matchType);
    }

    private String getCharacterClassKey() {
        if (this.aCharIterator.peek() == '{') {
            this.aCharIterator.skip();
            return this.aCharIterator.nextUntil('}');
        }
        return this.aCharIterator.next(1);
    }

    private static MatchType getMatchType(char parsedCharacter, char positiveMatchCharacter) {
        return parsedCharacter == positiveMatchCharacter ? MatchType.POSITIVE : MatchType.NEGATIVE;
    }

    private Repeat handleRepeatInCurvyBraces(int startPos, Node repeatNode) {
        StringBuilder sb = new StringBuilder(10);
        int min = -1;
        int contextIndex = this.aCharIterator.prevPos();
        block9: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next();
            switch (c) {
                case ',': {
                    int tmpContextIndex = this.aCharIterator.prevPos() - 1;
                    try {
                        min = Integer.parseInt(sb.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new RgxGenParseException("Malformed lower bound number." + this.aCharIterator.context(tmpContextIndex), e);
                    }
                    sb.delete(0, sb.length());
                    continue block9;
                }
                case '}': {
                    if (min == -1) {
                        return new Repeat(this.aCharIterator.substringToCurrPos(startPos), repeatNode, Integer.parseInt(sb.toString()));
                    }
                    if (sb.length() == 0) {
                        return Repeat.minimum(this.aCharIterator.substringToCurrPos(startPos), repeatNode, min);
                    }
                    try {
                        return new Repeat(this.aCharIterator.substringToCurrPos(startPos), repeatNode, min, Integer.parseInt(sb.toString()));
                    }
                    catch (NumberFormatException e) {
                        throw new RgxGenParseException("Malformed upper bound number." + this.aCharIterator.context(), e);
                    }
                }
                case '\\': {
                    throw new RgxGenParseException("Escape character inside curvy repetition is not supported. " + this.aCharIterator.context());
                }
            }
            sb.append(c);
        }
        throw new RgxGenParseException("Unbalanced '{' - missing '}' at " + this.aCharIterator.context(contextIndex));
    }

    private Repeat handleRepeat(char c, Node repeatNode) {
        int startPos = this.aNodesStartPos.get(repeatNode);
        Repeat node = switch (c) {
            case '*' -> Repeat.minimum(this.aCharIterator.substringToCurrPos(startPos), repeatNode, 0);
            case '?' -> new Repeat(this.aCharIterator.substringToCurrPos(startPos), repeatNode, 0, 1);
            case '+' -> Repeat.minimum(this.aCharIterator.substringToCurrPos(startPos), repeatNode, 1);
            case '{' -> this.handleRepeatInCurvyBraces(startPos, repeatNode);
            default -> throw new RgxGenParseException("Unknown repetition character '" + c + "'" + this.aCharIterator.context());
        };
        this.aNodesStartPos.put(node, startPos);
        return node;
    }

    private Node sequenceOrNot(int startPos, List<Node> nodes, List<Node> choices, boolean isChoice, Integer captureGroupIndex) {
        Node resultNode;
        if (nodes.size() == 1) {
            resultNode = nodes.get(0);
        } else if (isChoice) {
            if (choices.isEmpty()) {
                throw new RgxGenParseException("Empty nodes");
            }
            resultNode = new Choice(this.aCharIterator.substringToCurrPos(startPos), choices.toArray(ConstantsProvider.EMPTY_NODES_ARR));
        } else {
            if (nodes.isEmpty()) {
                throw new RgxGenParseException("Empty nodes");
            }
            resultNode = new Sequence(this.aCharIterator.substringToCurrPos(startPos), nodes.toArray(ConstantsProvider.EMPTY_NODES_ARR));
        }
        this.aNodesStartPos.put(resultNode, startPos);
        if (captureGroupIndex == null) {
            return resultNode;
        }
        Group group = new Group(this.aCharIterator.substringToCurrPos(startPos), captureGroupIndex, resultNode);
        this.aNodesStartPos.put(group, startPos);
        return group;
    }

    private Node handleSquareBrackets() {
        int openSquareBraceIndex = this.aCharIterator.prevPos();
        MatchType matchType = DefaultTreeBuilder.determineSymbolSetMatchType(this.aCharIterator);
        StringBuilder characters = new StringBuilder(this.aCharIterator.remaining());
        ArrayList<SymbolRange> symbolRanges = new ArrayList<SymbolRange>();
        ArrayList<SymbolSet> symbolSets = new ArrayList<SymbolSet>();
        boolean rangeStarted = false;
        block5: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next();
            switch (c) {
                case ']': {
                    String pattern = this.aCharIterator.substringToCurrPos(openSquareBraceIndex);
                    SymbolSet finalSymbolSet = DefaultTreeBuilder.createSymbolSetFromSquareBrackets(pattern, matchType, characters.toString(), symbolRanges, symbolSets);
                    this.aNodesStartPos.put(finalSymbolSet, openSquareBraceIndex);
                    return finalSymbolSet;
                }
                case '-': {
                    if (this.aCharIterator.peek() == ']' || this.aCharIterator.peek(-2) == '[') {
                        characters.append('-');
                        continue block5;
                    }
                    rangeStarted = true;
                    continue block5;
                }
                case '\\': {
                    Optional<SymbolSet> symbolSet = this.handleBackslashInsideSquareBrackets(characters);
                    if (rangeStarted) {
                        if (symbolSet.isPresent()) {
                            throw new RgxGenParseException("Cannot make range with a shorthand escape sequences before '" + this.aCharIterator.context() + "'");
                        }
                        DefaultTreeBuilder.handleSymbolRange(characters, symbolRanges);
                    } else {
                        symbolSet.ifPresent(symbolSets::add);
                    }
                    rangeStarted = false;
                    continue block5;
                }
            }
            characters.append(c);
            if (!rangeStarted) continue;
            DefaultTreeBuilder.handleSymbolRange(characters, symbolRanges);
            rangeStarted = false;
        }
        throw new RgxGenParseException("Unexpected End Of Expression. Didn't find closing ']'" + this.aCharIterator.context(openSquareBraceIndex));
    }

    private static MatchType determineSymbolSetMatchType(CharIterator charIterator) {
        if (charIterator.peek() == '^') {
            charIterator.skip();
            return MatchType.NEGATIVE;
        }
        return MatchType.POSITIVE;
    }

    private Optional<SymbolSet> handleBackslashInsideSquareBrackets(StringBuilder characters) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        StringBuilder sb = new StringBuilder();
        this.handleEscapedCharacter(sb, nodes, false);
        characters.append((CharSequence)sb);
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        if (nodes.size() > 1) {
            throw new RgxGenParseException("Multiple nodes found inside square brackets escape sequence before '" + this.aCharIterator.context() + "'");
        }
        return Optional.of((SymbolSet)nodes.get(0));
    }

    private static void handleSymbolRange(StringBuilder characters, Collection<SymbolRange> symbolRanges) {
        if (characters.length() < 2) {
            characters.append('-');
        } else {
            char lastChar = characters.charAt(characters.length() - 1);
            char firstChar = characters.charAt(characters.length() - 2);
            characters.delete(characters.length() - 2, characters.length());
            symbolRanges.add(SymbolRange.range(firstChar, lastChar));
        }
    }

    private static SymbolSet createSymbolSetFromSquareBrackets(String pattern, MatchType matchType, String sb, List<SymbolRange> externalRanges, Collection<SymbolSet> externalSets) {
        RgxGenCharsDefinition positiveMatchDefinitions = RgxGenCharsDefinition.of(externalRanges);
        if (!sb.isEmpty()) {
            positiveMatchDefinitions.withCharacters(sb.toCharArray());
        }
        boolean isAscii = true;
        boolean hasModifiedExclusionChars = externalSets.stream().anyMatch(SymbolSet::hasModifiedExclusionChars);
        RgxGenCharsDefinition negativeMatchDefinitions = hasModifiedExclusionChars ? RgxGenCharsDefinition.of(positiveMatchDefinitions) : null;
        for (SymbolSet symbolSet : externalSets) {
            isAscii = isAscii && symbolSet.isAscii();
            positiveMatchDefinitions.withCharacters(symbolSet.getSymbols()).withRanges(symbolSet.getSymbolRanges());
            if (!hasModifiedExclusionChars) continue;
            if (symbolSet.hasModifiedExclusionChars()) {
                negativeMatchDefinitions.addAll(symbolSet.getNegativeMatchExclusionChars());
                continue;
            }
            negativeMatchDefinitions.withCharacters(symbolSet.getSymbols()).withRanges(symbolSet.getSymbolRanges());
        }
        if (isAscii) {
            return SymbolSet.ofAscii(pattern, positiveMatchDefinitions, negativeMatchDefinitions, matchType);
        }
        return SymbolSet.ofUnicode(pattern, positiveMatchDefinitions, negativeMatchDefinitions, matchType);
    }

    public void build() {
        this.aNode = this.parseGroup(this.aCharIterator.prevPos() + 1, GroupType.NON_CAPTURE_GROUP);
        if (this.aCharIterator.hasNext()) {
            throw new RgxGenParseException("Expression was not fully parsed: " + this.aCharIterator.context());
        }
    }

    @Override
    public Node get() {
        if (this.aNode == null) {
            this.build();
        }
        return this.aNode;
    }
}

