/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators.suppliers;

import com.github.curiousoddman.rgxgen.iterators.ReferenceIterator;
import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class GroupIteratorSupplier
implements Supplier<StringIterator> {
    private final Supplier<StringIterator> aIteratorSupplier;
    private final Map<Integer, List<ReferenceIterator>> aReferenceIteratorMap;
    private final Map<Integer, StringIterator> aGroupIteratorsMap;
    private final int aIndex;

    public GroupIteratorSupplier(Supplier<StringIterator> iteratorSupplier, Map<Integer, List<ReferenceIterator>> referenceIteratorMap, Map<Integer, StringIterator> groupIteratorsMap, int index) {
        this.aIteratorSupplier = iteratorSupplier;
        this.aReferenceIteratorMap = referenceIteratorMap;
        this.aGroupIteratorsMap = groupIteratorsMap;
        this.aIndex = index;
    }

    @Override
    public StringIterator get() {
        StringIterator stringIterator = this.aIteratorSupplier.get();
        this.aGroupIteratorsMap.put(this.aIndex, stringIterator);
        List orDefault = this.aReferenceIteratorMap.getOrDefault(this.aIndex, Collections.emptyList());
        for (ReferenceIterator referenceIterator : orDefault) {
            referenceIterator.setOther(stringIterator);
        }
        return stringIterator;
    }
}

