/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket;

import com.badlogic.gdx.Gdx;
import com.github.czyzby.websocket.WebSocket;
import com.github.czyzby.websocket.WebSocketListener;
import com.github.czyzby.websocket.data.WebSocketCloseCode;
import com.github.czyzby.websocket.data.WebSocketException;
import com.github.czyzby.websocket.serialization.SerializationException;

public abstract class AbstractWebSocketListener
implements WebSocketListener {
    @Override
    public boolean onOpen(WebSocket webSocket) {
        return false;
    }

    @Override
    public boolean onClose(WebSocket webSocket, WebSocketCloseCode code, String reason) {
        return false;
    }

    @Override
    public boolean onMessage(WebSocket webSocket, String packet) {
        try {
            return this.onMessage(webSocket, webSocket.getSerializer().deserialize(packet));
        }
        catch (WebSocketException exception) {
            return this.onError(webSocket, exception);
        }
        catch (SerializationException exception) {
            return this.onError(webSocket, exception);
        }
    }

    @Override
    public boolean onMessage(WebSocket webSocket, byte[] packet) {
        try {
            return this.onMessage(webSocket, webSocket.getSerializer().deserialize(packet));
        }
        catch (WebSocketException exception) {
            return this.onError(webSocket, exception);
        }
        catch (SerializationException exception) {
            return this.onError(webSocket, exception);
        }
    }

    protected abstract boolean onMessage(WebSocket var1, Object var2) throws WebSocketException;

    @Override
    public boolean onError(WebSocket webSocket, Throwable error) {
        Gdx.app.error(webSocket.toString(), "Web socket reported an error.", error);
        return false;
    }
}

