/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket;

import com.badlogic.gdx.utils.ObjectMap;
import com.github.czyzby.websocket.AbstractWebSocketListener;
import com.github.czyzby.websocket.WebSocket;
import com.github.czyzby.websocket.data.WebSocketException;

public class WebSocketHandler
extends AbstractWebSocketListener {
    private final ObjectMap<Class<?>, Handler<Object>> handlers = new ObjectMap();
    private final Handler<Object> unknown = new Handler<Object>(){

        @Override
        public boolean handle(WebSocket webSocket, Object packet) {
            if (WebSocketHandler.this.failIfNoHandler) {
                WebSocketHandler.this.onError(webSocket, new WebSocketException("Unknown packet type: " + packet.getClass()));
            }
            return false;
        }
    };
    private boolean failIfNoHandler = true;

    public void registerHandler(Class<?> packetClass, Handler<?> handler) {
        this.handlers.put(packetClass, handler);
    }

    public void setFailIfNoHandler(boolean failIfNoHandler) {
        this.failIfNoHandler = failIfNoHandler;
    }

    @Override
    protected boolean onMessage(WebSocket webSocket, Object packet) throws WebSocketException {
        try {
            return ((Handler)this.handlers.get(packet.getClass(), this.unknown)).handle(webSocket, packet);
        }
        catch (Exception exception) {
            return this.onError(webSocket, new WebSocketException("Unable to handle the received packet: " + packet, exception));
        }
    }

    public static class EmptyHandler
    implements Handler<Object> {
        @Override
        public boolean handle(WebSocket webSocket, Object packet) {
            return false;
        }
    }

    public static interface Handler<Packet> {
        public boolean handle(WebSocket var1, Packet var2);
    }
}

