/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket;

import com.badlogic.gdx.Gdx;
import com.github.czyzby.websocket.WebSocket;
import com.github.czyzby.websocket.data.WebSocketException;
import com.github.czyzby.websocket.serialization.Serializer;
import com.github.czyzby.websocket.serialization.impl.JsonSerializer;

public class WebSockets {
    public static final String WEB_SOCKET_ADDRESS_PREFIX = "ws://";
    public static final String SECURE_WEB_SOCKET_ADDRESS_PREFIX = "wss://";
    protected static WebSocketFactory FACTORY;
    public static Serializer DEFAULT_SERIALIZER;

    private WebSockets() {
    }

    public static WebSocket newSocket(String url) {
        if (FACTORY == null) {
            throw new WebSocketException("Web sockets are not initiated.");
        }
        return FACTORY.newWebSocket(url);
    }

    public static String toWebSocketUrl(String host, int port) {
        return WebSockets.toWebSocketUrl(host, port, null);
    }

    public static String toWebSocketUrl(String host, int port, String contentPath) {
        return WebSockets.toUrl(WEB_SOCKET_ADDRESS_PREFIX, host, port, contentPath);
    }

    public static String toSecureWebSocketUrl(String host, int port) {
        return WebSockets.toSecureWebSocketUrl(host, port, null);
    }

    public static String toSecureWebSocketUrl(String host, int port, String contentPath) {
        return WebSockets.toUrl(SECURE_WEB_SOCKET_ADDRESS_PREFIX, host, port, contentPath);
    }

    private static String toUrl(String prefix, String host, int port, String contentPath) {
        if (WebSockets.isPortValid(port)) {
            return prefix + host + ":" + port + "/" + (contentPath == null ? "" : contentPath);
        }
        throw new WebSocketException("Invalid port: " + port);
    }

    public static boolean isPortValid(int port) {
        return port > 0 && port <= 65535;
    }

    public static void closeGracefully(WebSocket webSocket) {
        if (webSocket != null) {
            try {
                webSocket.close();
            }
            catch (Exception exception) {
                Gdx.app.debug("WebSocket", exception.getMessage());
            }
        }
    }

    static {
        DEFAULT_SERIALIZER = new JsonSerializer();
    }

    protected static interface WebSocketFactory {
        public WebSocket newWebSocket(String var1);
    }
}

