/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket.data;

import com.github.czyzby.websocket.data.WebSocketException;

public enum WebSocketCloseCode {
    NORMAL(1000),
    AWAY(1001),
    UNCONFORMED(1002),
    UNACCEPTABLE(1003),
    NONE(1005),
    ABNORMAL(1006),
    INCONSISTENT(1007),
    VIOLATED(1008),
    OVERSIZE(1009),
    UNEXTENDED(1010),
    UNEXPECTED(1011),
    INSECURE(1015);

    private final int code;

    private WebSocketCloseCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static WebSocketCloseCode getByCode(int code) throws WebSocketException {
        if (code == WebSocketCloseCode.INSECURE.code) {
            return INSECURE;
        }
        if (code < WebSocketCloseCode.NORMAL.code || code > WebSocketCloseCode.UNEXPECTED.code || code == 1004) {
            throw new WebSocketException("Unexpected close code: " + code);
        }
        if (code < 1004) {
            return WebSocketCloseCode.values()[code - 1000];
        }
        return WebSocketCloseCode.values()[code - 1001];
    }

    public static WebSocketCloseCode getByCodeOrElse(int code, WebSocketCloseCode alternative) {
        if (code == WebSocketCloseCode.INSECURE.code) {
            return INSECURE;
        }
        if (code < WebSocketCloseCode.NORMAL.code || code > WebSocketCloseCode.UNEXPECTED.code || code == 1004) {
            return alternative;
        }
        if (code < 1004) {
            return WebSocketCloseCode.values()[code - 1000];
        }
        return WebSocketCloseCode.values()[code - 1001];
    }
}

