/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket.impl;

import com.badlogic.gdx.utils.Array;
import com.github.czyzby.websocket.WebSocket;
import com.github.czyzby.websocket.WebSocketListener;
import com.github.czyzby.websocket.WebSockets;
import com.github.czyzby.websocket.data.WebSocketCloseCode;
import com.github.czyzby.websocket.data.WebSocketException;
import com.github.czyzby.websocket.data.WebSocketState;
import com.github.czyzby.websocket.serialization.Serializer;
import java.util.Iterator;

public abstract class AbstractWebSocket
implements WebSocket {
    private final String url;
    private final Array<WebSocketListener> listeners = new Array(2);
    private Serializer serializer = WebSockets.DEFAULT_SERIALIZER;
    private boolean serializeAsString;
    private boolean sendGracefully;

    public AbstractWebSocket(String url) {
        this.url = url;
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void setSerializeAsString(boolean serializeAsString) {
        this.serializeAsString = serializeAsString;
    }

    @Override
    public void setSendGracefully(boolean sendGracefully) {
        this.sendGracefully = sendGracefully;
    }

    @Override
    public void addListener(WebSocketListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeListener(WebSocketListener listener) {
        this.listeners.removeValue((Object)listener, true);
    }

    protected Array<WebSocketListener> getListeners() {
        return this.listeners;
    }

    protected void postOpenEvent() {
        WebSocketListener listener;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && !(listener = (WebSocketListener)iterator.next()).onOpen(this)) {
        }
    }

    protected void postCloseEvent(WebSocketCloseCode closeCode, String reason) {
        WebSocketListener listener;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && !(listener = (WebSocketListener)iterator.next()).onClose(this, closeCode, reason)) {
        }
    }

    protected void postErrorEvent(Throwable error) {
        WebSocketListener listener;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && !(listener = (WebSocketListener)iterator.next()).onError(this, error)) {
        }
    }

    protected void postMessageEvent(byte[] packet) {
        WebSocketListener listener;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && !(listener = (WebSocketListener)iterator.next()).onMessage((WebSocket)this, packet)) {
        }
    }

    protected void postMessageEvent(String packet) {
        WebSocketListener listener;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext() && !(listener = (WebSocketListener)iterator.next()).onMessage((WebSocket)this, packet)) {
        }
    }

    @Override
    public boolean isSecure() {
        String secureWebSocketPrefix = "wss";
        return this.getUrl().substring(0, "wss".length()).equalsIgnoreCase("wss");
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void sendKeepAlivePacket() throws WebSocketException {
        this.send("");
    }

    @Override
    public void send(Object packet) throws WebSocketException {
        try {
            if (packet != null) {
                if (this.serializeAsString) {
                    this.send(this.serializer.serializeAsString(packet));
                } else {
                    this.send(this.serializer.serialize(packet));
                }
            }
        }
        catch (WebSocketException exception) {
            this.onSendingException(exception);
        }
        catch (Exception exception) {
            this.onSendingException(exception);
        }
    }

    @Override
    public boolean isOpen() {
        return this.getState() == WebSocketState.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.getState() == WebSocketState.CLOSED;
    }

    @Override
    public boolean isClosing() {
        return this.getState() == WebSocketState.CLOSING;
    }

    @Override
    public boolean isConnecting() {
        return this.getState() == WebSocketState.CONNECTING;
    }

    protected void onSendingException(Exception exception) {
        if (!this.sendGracefully) {
            throw new WebSocketException("Unable to send packet.", exception);
        }
        this.postErrorEvent(exception);
    }

    protected void onSendingException(WebSocketException exception) {
        if (!this.sendGracefully) {
            throw exception;
        }
        this.postErrorEvent(exception);
    }

    @Override
    public void send(byte[] packet) throws WebSocketException {
        try {
            if (packet != null) {
                this.sendBinary(packet);
            }
        }
        catch (WebSocketException exception) {
            this.onSendingException(exception);
        }
        catch (Exception exception) {
            this.onSendingException(exception);
        }
    }

    @Override
    public void send(String packet) throws WebSocketException {
        try {
            if (packet != null) {
                this.sendString(packet);
            }
        }
        catch (WebSocketException exception) {
            this.onSendingException(exception);
        }
        catch (Exception exception) {
            this.onSendingException(exception);
        }
    }

    protected abstract void sendBinary(byte[] var1) throws Exception;

    protected abstract void sendString(String var1) throws Exception;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void close() throws WebSocketException {
        this.close(WebSocketCloseCode.NORMAL, null);
    }

    @Override
    public void close(String reason) throws WebSocketException {
        this.close(WebSocketCloseCode.NORMAL, reason);
    }

    @Override
    public void close(WebSocketCloseCode code) throws WebSocketException {
        this.close(code, null);
    }
}

