/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket.net;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.ServerSocket;
import com.badlogic.gdx.net.ServerSocketHints;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.github.czyzby.websocket.WebSocket;
import com.github.czyzby.websocket.WebSockets;

public class ExtendedNet
implements Net {
    private final Net net;

    public ExtendedNet(Net net) {
        this.net = net;
    }

    public static ExtendedNet wrapNet() {
        ExtendedNet extendedNet = new ExtendedNet(Gdx.net);
        Gdx.net = extendedNet;
        return extendedNet;
    }

    public static ExtendedNet getNet() {
        if (!(Gdx.net instanceof ExtendedNet)) {
            return ExtendedNet.wrapNet();
        }
        return (ExtendedNet)Gdx.net;
    }

    public void sendHttpRequest(Net.HttpRequest httpRequest, Net.HttpResponseListener httpResponseListener) {
        this.net.sendHttpRequest(httpRequest, httpResponseListener);
    }

    public void cancelHttpRequest(Net.HttpRequest httpRequest) {
        this.net.cancelHttpRequest(httpRequest);
    }

    public ServerSocket newServerSocket(Net.Protocol protocol, String hostname, int port, ServerSocketHints hints) {
        return this.net.newServerSocket(protocol, hostname, port, hints);
    }

    public ServerSocket newServerSocket(Net.Protocol protocol, int port, ServerSocketHints hints) {
        return this.net.newServerSocket(protocol, port, hints);
    }

    public Socket newClientSocket(Net.Protocol protocol, String host, int port, SocketHints hints) {
        return this.net.newClientSocket(protocol, host, port, hints);
    }

    public boolean openURI(String URI) {
        return this.net.openURI(URI);
    }

    public WebSocket newWebSocket(String host, int port) {
        return WebSockets.newSocket(WebSockets.toWebSocketUrl(host, port));
    }

    public WebSocket newWebSocket(String host, int port, String content) {
        return WebSockets.newSocket(WebSockets.toWebSocketUrl(host, port, content));
    }

    public WebSocket newSecureWebSocket(String host, int port) {
        return WebSockets.newSocket(WebSockets.toSecureWebSocketUrl(host, port));
    }

    public WebSocket newSecureWebSocket(String host, int port, String content) {
        return WebSockets.newSocket(WebSockets.toSecureWebSocketUrl(host, port, content));
    }
}

