/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket.serialization.impl;

import com.github.czyzby.websocket.serialization.SerializationException;
import com.github.czyzby.websocket.serialization.Serializer;
import java.io.UnsupportedEncodingException;

public abstract class AbstractStringSerializer
implements Serializer {
    @Override
    public byte[] serialize(Object object) {
        try {
            return this.serializeAsString(object).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new SerializationException("Unexpected: UTF-8 format not supported.", exception);
        }
    }

    @Override
    public Object deserialize(byte[] data) {
        try {
            return this.deserialize(new String(data, "UTF-8"));
        }
        catch (UnsupportedEncodingException exception) {
            throw new SerializationException("Unexpected: UTF-8 format not supported.", exception);
        }
    }
}

