/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket.serialization.impl;

import com.badlogic.gdx.utils.Base64Coder;
import com.github.czyzby.websocket.serialization.SerializationException;
import com.github.czyzby.websocket.serialization.Serializer;
import java.io.UnsupportedEncodingException;

public class Base64Serializer
implements Serializer {
    private final Serializer serializer;
    private boolean useUrlSafeEncoding;

    public Base64Serializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    @Override
    public String serializeAsString(Object object) {
        String serialized = this.serializer.serializeAsString(object);
        try {
            return Base64Coder.encodeString((String)serialized, (boolean)this.useUrlSafeEncoding);
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to encode data into BASE64: " + serialized, exception);
        }
    }

    @Override
    public byte[] serialize(Object object) {
        byte[] serialized = this.serializer.serialize(object);
        try {
            return Base64Coder.encodeString((String)new String(serialized, "UTF-8"), (boolean)this.useUrlSafeEncoding).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            throw new SerializationException("Unexpected: UTF-8 format not supported.", exception);
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to encode data into BASE64.", exception);
        }
    }

    @Override
    public Object deserialize(String data) {
        String decoded;
        try {
            decoded = Base64Coder.decodeString((String)data, (boolean)this.useUrlSafeEncoding);
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to decode data from BASE64: " + data, exception);
        }
        return this.serializer.deserialize(decoded);
    }

    @Override
    public Object deserialize(byte[] data) {
        String decoded;
        try {
            decoded = Base64Coder.decodeString((String)new String(data, "UTF-8"), (boolean)this.useUrlSafeEncoding);
        }
        catch (UnsupportedEncodingException exception) {
            throw new SerializationException("Unexpected: UTF-8 format not supported.", exception);
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to decode data from BASE64: " + data, exception);
        }
        return this.serializer.deserialize(decoded);
    }

    public void setUseUrlSafeEncoding(boolean useUrlSafeEncoding) {
        this.useUrlSafeEncoding = useUrlSafeEncoding;
    }
}

