/*
 * Decompiled with CFR 0.152.
 */
package com.github.czyzby.websocket.serialization.impl;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.github.czyzby.websocket.serialization.SerializationException;
import com.github.czyzby.websocket.serialization.impl.AbstractStringSerializer;

public class JsonSerializer
extends AbstractStringSerializer {
    private final Json json = new Json();

    public JsonSerializer() {
        this.json.setOutputType(JsonWriter.OutputType.javascript);
    }

    public void setPreserveClassName(boolean preserveClassName) {
        this.json.setTypeName(preserveClassName ? "class" : null);
    }

    @Override
    public String serializeAsString(Object object) {
        try {
            return this.json.toJson(object, Object.class);
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to serialize object to JSON.", exception);
        }
    }

    @Override
    public Object deserialize(String data) {
        try {
            return this.json.fromJson(null, data);
        }
        catch (Exception exception) {
            throw new SerializationException("Unable to deserialize object from JSON.", exception);
        }
    }

    public Json getJson() {
        return this.json;
    }
}

