/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.equator;

import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractEquator
implements Equator {
    private static final List<Class<?>> WRAPPER = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, String.class);

    @Override
    public boolean isEquals(Object first, Object second) {
        List<FieldInfo> diff = this.getDiffFields(first, second);
        return diff == null || diff.isEmpty();
    }

    protected boolean isFieldEquals(FieldInfo fieldInfo) {
        return this.nullableEquals(fieldInfo.getFirstVal(), fieldInfo.getSecondVal());
    }

    protected List<FieldInfo> comparePrimitive(Object first, Object second) {
        Object obj = first == null ? second : first;
        Class<?> clazz = obj.getClass();
        boolean eq = Objects.equals(first, second);
        if (eq) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new FieldInfo(clazz.getSimpleName(), clazz, first, second));
    }

    protected boolean isPrimitive(Object first, Object second) {
        Object obj = first == null ? second : first;
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || WRAPPER.contains(clazz);
    }

    private boolean nullableEquals(Object first, Object second) {
        if (first instanceof Collection && second instanceof Collection) {
            return Objects.deepEquals(((Collection)first).toArray(), ((Collection)second).toArray());
        }
        return Objects.deepEquals(first, second);
    }
}

