/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.equator;

import com.github.dadiyang.equator.AbstractEquator;
import com.github.dadiyang.equator.FieldInfo;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FieldBaseEquator
extends AbstractEquator {
    @Override
    public List<FieldInfo> getDiffFields(Object first, Object second) {
        Field[] fields;
        if (first == second) {
            return Collections.emptyList();
        }
        if (this.isPrimitive(first, second)) {
            return this.comparePrimitive(first, second);
        }
        Object obj = first == null ? second : first;
        Class<?> clazz = obj.getClass();
        LinkedList<FieldInfo> diffField = new LinkedList<FieldInfo>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            try {
                field.setAccessible(true);
                Object firstVal = first == null ? null : field.get(first);
                Object secondVal = second == null ? null : field.get(second);
                FieldInfo fieldInfo = new FieldInfo(fieldName, field.getType(), firstVal, secondVal);
                boolean eq = this.isFieldEquals(fieldInfo);
                if (eq) continue;
                diffField.add(fieldInfo);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("\u83b7\u53d6\u5c5e\u6027\u8fdb\u884c\u6bd4\u5bf9\u53d1\u751f\u5f02\u5e38: " + fieldName, e);
            }
        }
        return diffField;
    }
}

