/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.equator;

import com.github.dadiyang.equator.AbstractEquator;
import com.github.dadiyang.equator.FieldInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class GetterBaseEquator
extends AbstractEquator {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String GET_IS = "get|is";
    private static final String GET_CLASS = "getClass";

    @Override
    public List<FieldInfo> getDiffFields(Object first, Object second) {
        if (first == null && second == null) {
            return Collections.emptyList();
        }
        if (this.isPrimitive(first, second)) {
            return this.comparePrimitive(first, second);
        }
        LinkedList<FieldInfo> diffField = new LinkedList<FieldInfo>();
        Object obj = first == null ? second : first;
        Map<String, Method> getters = this.getAllGetters(obj.getClass());
        for (Map.Entry<String, Method> entry : getters.entrySet()) {
            String fieldName = entry.getKey();
            Method method = entry.getValue();
            try {
                Object secondVal;
                Object firstVal = first == null ? null : method.invoke(first, new Object[0]);
                Object object = secondVal = second == null ? null : method.invoke(second, new Object[0]);
                FieldInfo fieldInfo = new FieldInfo(fieldName, method.getReturnType(), firstVal, secondVal);
                boolean eq = this.isFieldEquals(fieldInfo);
                if (eq) continue;
                diffField.add(fieldInfo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("\u83b7\u53d6\u5c5e\u6027\u8fdb\u884c\u6bd4\u5bf9\u53d1\u751f\u5f02\u5e38: " + fieldName, e);
            }
        }
        return diffField;
    }

    private Map<String, Method> getAllGetters(Class<?> clazz) {
        Method[] methods;
        LinkedHashMap<String, Method> getters = new LinkedHashMap<String, Method>(8);
        for (Method m : methods = clazz.getMethods()) {
            String fieldName;
            if (m.getParameterTypes().length > 0) continue;
            if ((m.getReturnType() == Boolean.class || m.getReturnType() == Boolean.TYPE) && m.getName().startsWith(IS)) {
                fieldName = this.uncapitalize(m.getName().substring(2));
                getters.put(fieldName, m);
                continue;
            }
            if (!m.getName().startsWith(GET) || GET_CLASS.equals(m.getName())) continue;
            fieldName = this.uncapitalize(m.getName().replaceFirst(GET_IS, ""));
            getters.put(fieldName, m);
        }
        return getters;
    }

    private String uncapitalize(String str) {
        int codepoint;
        int newCodePoint;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toLowerCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codepoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }
}

