/*
 * Decompiled with CFR 0.152.
 */
package eu.drus.jpa.unit.api;

import eu.drus.jpa.unit.core.JpaUnitContext;
import eu.drus.jpa.unit.spi.DecoratorExecutor;
import eu.drus.jpa.unit.spi.ExecutionContext;
import eu.drus.jpa.unit.spi.FeatureResolver;
import eu.drus.jpa.unit.spi.TestMethodInvocation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JpaUnit
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private final DecoratorExecutor executor = new DecoratorExecutor();

    public void beforeAll(ExtensionContext context) throws Exception {
        Class testClass = (Class)context.getTestClass().get();
        this.executor.processBeforeAll((ExecutionContext)JpaUnitContext.getInstance((Class)testClass), testClass);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Class testClass = (Class)context.getTestClass().get();
        this.executor.processAfterAll((ExecutionContext)JpaUnitContext.getInstance((Class)testClass), testClass);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.executor.processBefore(this.createTestMethodInvocation(context, true));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.executor.processAfter(this.createTestMethodInvocation(context, true));
    }

    private TestMethodInvocation createTestMethodInvocation(final ExtensionContext context, final boolean considerExceptions) {
        final JpaUnitContext ctx = JpaUnitContext.getInstance((Class)((Class)context.getTestClass().get()));
        return new TestMethodInvocation(){

            public Method getTestMethod() {
                return (Method)context.getTestMethod().get();
            }

            public ExecutionContext getContext() {
                return ctx;
            }

            public Class<?> getTestClass() {
                return (Class)context.getTestClass().get();
            }

            public boolean hasErrors() {
                return considerExceptions ? context.getExecutionException().isPresent() : false;
            }

            public FeatureResolver getFeatureResolver() {
                return FeatureResolver.newFeatureResolver((Method)this.getTestMethod(), this.getTestClass()).build();
            }

            public Object getTestInstance() {
                return context.getTestInstance().get();
            }
        };
    }
}

