/*
 * Decompiled with CFR 0.152.
 */
package eu.drus.jpa.unit.api;

import eu.drus.jpa.unit.core.JpaUnitContext;
import eu.drus.jpa.unit.spi.DecoratorExecutor;
import eu.drus.jpa.unit.spi.ExecutionContext;
import eu.drus.jpa.unit.spi.FeatureResolver;
import eu.drus.jpa.unit.spi.TestInvocation;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JpaUnit
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private final DecoratorExecutor executor = new DecoratorExecutor();

    public void beforeAll(ExtensionContext context) throws Exception {
        this.executor.processBeforeAll(this.createTestMethodInvocation(context, true));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.executor.processAfterAll(this.createTestMethodInvocation(context, true));
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.executor.processBefore(this.createTestMethodInvocation(context, true));
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.executor.processAfter(this.createTestMethodInvocation(context, true));
    }

    private TestInvocation createTestMethodInvocation(final ExtensionContext context, final boolean considerExceptions) {
        final JpaUnitContext ctx = JpaUnitContext.getInstance((Class)((Class)context.getTestClass().get()));
        return new TestInvocation(){

            public Optional<Method> getTestMethod() {
                return context.getTestMethod();
            }

            public ExecutionContext getContext() {
                return ctx;
            }

            public Class<?> getTestClass() {
                return (Class)context.getTestClass().get();
            }

            public Optional<Throwable> getException() {
                return considerExceptions ? context.getExecutionException() : Optional.empty();
            }

            public FeatureResolver getFeatureResolver() {
                FeatureResolver.Builder builder = FeatureResolver.newFeatureResolver(this.getTestClass());
                Optional<Method> method = this.getTestMethod();
                if (method.isPresent()) {
                    builder.withTestMethod(method.get());
                }
                return builder.build();
            }

            public Optional<Object> getTestInstance() {
                return context.getTestInstance();
            }
        };
    }
}

