/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.enumerator;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class Enumerator<T>
implements Iterator<List<T>>,
Iterable<List<T>> {
    private long enumSize;
    private long index;
    protected int k;
    protected List<T> items;

    static long factorial(long n) {
        if (n < 0L) {
            String msg = "n cannot be less than 0. (" + n + ")";
            throw new RuntimeException(msg);
        }
        if (n == 0L) {
            return 1L;
        }
        long ret = 1L;
        for (long i = n; i > 1L; --i) {
            ret *= i;
        }
        return ret;
    }

    static long nCk(long n, long k) {
        return Enumerator.nPk(n, k) / Enumerator.factorial(k);
    }

    static long nHk(int n, int k) {
        long ret = Enumerator.nCk(n + k - 1, k);
        return ret;
    }

    static long nPk(long n, long k) {
        long ret = 1L;
        for (long i = n; i > n - k; --i) {
            ret *= i;
        }
        return ret;
    }

    protected Enumerator(List<T> items, int k) {
        this.items = items;
        this.k = k;
        this.enumSize = this.size();
    }

    public List<T> get(long index) {
        if (index < this.enumSize) {
            return this.get_Protected(index);
        }
        String msg = String.format("Index (%d) must be less than %d", index, this.enumSize);
        throw new IndexOutOfBoundsException(msg);
    }

    protected abstract List<T> get_Protected(long var1);

    public abstract long size();

    @Override
    public boolean hasNext() {
        return this.index < this.enumSize;
    }

    @Override
    public List<T> next() {
        if (!this.hasNext()) {
            String message = "No more element in this enumberator.";
            throw new NoSuchElementException(message);
        }
        return this.get_Protected(this.index++);
    }

    @Override
    public void remove() {
        String message = "This operation is not supported.";
        throw new UnsupportedOperationException(message);
    }

    @Override
    public Iterator<List<T>> iterator() {
        return this;
    }
}

