/*
 * Decompiled with CFR 0.152.
 */
package com.github.arangobee;

import com.arangodb.ArangoDatabase;
import com.arangodb.springframework.core.template.ArangoTemplate;
import com.github.arangobee.changeset.ChangeEntry;
import com.github.arangobee.dao.ChangeEntryDao;
import com.github.arangobee.exception.ArangobeeChangeSetException;
import com.github.arangobee.exception.ArangobeeConfigurationException;
import com.github.arangobee.exception.ArangobeeConnectionException;
import com.github.arangobee.exception.ArangobeeException;
import com.github.arangobee.utils.ChangeService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class Arangobee
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(Arangobee.class);
    private static final String DEFAULT_CHANGELOG_COLLECTION_NAME = "dbchangelog";
    private static final String DEFAULT_LOCK_COLLECTION_NAME = "arangolock";
    private static final boolean DEFAULT_WAIT_FOR_LOCK = false;
    private static final long DEFAULT_CHANGE_LOG_LOCK_WAIT_TIME = 5L;
    private static final long DEFAULT_CHANGE_LOG_LOCK_POLL_RATE = 10L;
    private static final boolean DEFAULT_THROW_EXCEPTION_IF_CANNOT_OBTAIN_LOCK = false;
    private ChangeEntryDao dao;
    private String changeLogsScanPackage;
    private Environment springEnvironment;
    private final ArangoDatabase arangoDatabase;
    private final AutowireCapableBeanFactory autowireCapableBeanFactory;
    private final int autowireMode;

    public Arangobee(ArangoDatabase arangoDatabase, AutowireCapableBeanFactory autowireCapableBeanFactory) {
        this(arangoDatabase, autowireCapableBeanFactory, 0);
    }

    public Arangobee(ArangoDatabase arangoDatabase, AutowireCapableBeanFactory autowireCapableBeanFactory, int autowireMode) {
        this.arangoDatabase = arangoDatabase;
        this.autowireCapableBeanFactory = autowireCapableBeanFactory;
        this.autowireMode = autowireMode;
        this.dao = new ChangeEntryDao(DEFAULT_CHANGELOG_COLLECTION_NAME, DEFAULT_LOCK_COLLECTION_NAME, false, 5L, 10L, false);
    }

    public Arangobee dao(ChangeEntryDao dao) {
        this.dao = dao;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        this.execute();
    }

    public void execute() throws ArangobeeException {
        this.validateConfig();
        this.dao.connectDb(this.arangoDatabase);
        String lock = this.dao.acquireProcessLock();
        if (lock == null) {
            throw new ArangobeeException("Arangobee did not acquire process lock. Exiting.");
        }
        logger.info("Arangobee acquired process lock, starting the data migration sequence..");
        try {
            this.executeMigration();
        }
        finally {
            logger.info("Arangobee is releasing process lock.");
            this.dao.releaseProcessLock(lock);
        }
        logger.info("Arangobee has finished his job.");
    }

    private void executeMigration() throws ArangobeeConnectionException, ArangobeeException {
        ChangeService service = new ChangeService(this.changeLogsScanPackage, this.springEnvironment);
        for (Class<?> changelogClass : service.fetchChangeLogs()) {
            Object changelogInstance = null;
            try {
                changelogInstance = changelogClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (this.autowireCapableBeanFactory != null) {
                    this.autowireCapableBeanFactory.autowireBeanProperties(changelogInstance, this.autowireMode, true);
                }
                List<Method> changesetMethods = service.fetchChangeSets(changelogInstance.getClass());
                for (Method changesetMethod : changesetMethods) {
                    ChangeEntry changeEntry = service.createChangeEntry(changesetMethod);
                    try {
                        if (this.dao.isNewChange(changeEntry)) {
                            this.executeChangeSetMethod(changesetMethod, changelogInstance, this.dao.getArangoDatabase());
                            this.dao.save(changeEntry);
                            logger.info(changeEntry + " applied");
                            continue;
                        }
                        if (service.isRunAlwaysChangeSet(changesetMethod)) {
                            this.executeChangeSetMethod(changesetMethod, changelogInstance, this.dao.getArangoDatabase());
                            logger.info(changeEntry + " reapplied");
                            continue;
                        }
                        logger.info(changeEntry + " passed over");
                    }
                    catch (ArangobeeChangeSetException e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            catch (NoSuchMethodException e) {
                throw new ArangobeeException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ArangobeeException(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw new ArangobeeException(targetException.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ArangobeeException(e.getMessage(), e);
            }
        }
    }

    private Object executeChangeSetMethod(Method changeSetMethod, Object changeLogInstance, ArangoDatabase arangoDatabase) throws IllegalAccessException, InvocationTargetException, ArangobeeChangeSetException {
        if (changeSetMethod.getParameterTypes().length == 2 && changeSetMethod.getParameterTypes()[0].equals(ArangoTemplate.class) && changeSetMethod.getParameterTypes()[1].equals(Environment.class)) {
            logger.debug("method with ArangoTemplate and environment arguments");
            return changeSetMethod.invoke(changeLogInstance, arangoDatabase, this.springEnvironment);
        }
        if (changeSetMethod.getParameterTypes().length == 1 && changeSetMethod.getParameterTypes()[0].equals(ArangoDatabase.class)) {
            logger.debug("method with DB argument");
            return changeSetMethod.invoke(changeLogInstance, arangoDatabase);
        }
        if (changeSetMethod.getParameterTypes().length == 0) {
            logger.debug("method with no params");
            return changeSetMethod.invoke(changeLogInstance, new Object[0]);
        }
        throw new ArangobeeChangeSetException("ChangeSet method " + changeSetMethod.getName() + " has wrong arguments list. Please see docs for more info!");
    }

    private void validateConfig() throws ArangobeeConfigurationException {
        if (this.arangoDatabase == null) {
            throw new ArangobeeConfigurationException("Database is not set.");
        }
        if (!StringUtils.hasText((String)this.changeLogsScanPackage)) {
            throw new ArangobeeConfigurationException("Scan package for changelogs is not set: use appropriate setter");
        }
    }

    public boolean isExecutionInProgress() throws ArangobeeConnectionException {
        return this.dao.isProccessLockHeld();
    }

    public Arangobee setChangeLogsScanPackage(String changeLogsScanPackage) {
        this.changeLogsScanPackage = changeLogsScanPackage;
        return this;
    }

    public Arangobee setWaitForLock(boolean waitForLock) {
        this.dao.setWaitForLock(waitForLock);
        return this;
    }

    public Arangobee setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.dao.setChangeLogLockWaitTime(changeLogLockWaitTime);
        return this;
    }

    public Arangobee setChangeLogLockPollRate(long changeLogLockPollRate) {
        this.dao.setChangeLogLockPollRate(changeLogLockPollRate);
        return this;
    }

    public Arangobee setThrowExceptionIfCannotObtainLock(boolean throwExceptionIfCannotObtainLock) {
        this.dao.setThrowExceptionIfCannotObtainLock(throwExceptionIfCannotObtainLock);
        return this;
    }

    public Arangobee setSpringEnvironment(Environment environment) {
        this.springEnvironment = environment;
        return this;
    }

    public Arangobee setChangelogCollectionName(String changelogCollectionName) {
        this.dao.setChangelogCollectionName(changelogCollectionName);
        return this;
    }

    public Arangobee setLockCollectionName(String lockCollectionName) {
        this.dao.setLockCollectionName(lockCollectionName);
        return this;
    }

    public void close() {
        this.dao.close();
    }
}

