/*
 * Decompiled with CFR 0.152.
 */
package com.github.arangobee.dao;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.BaseDocument;
import com.github.arangobee.changeset.ChangeEntry;
import com.github.arangobee.dao.ChangeEntryIndexDao;
import com.github.arangobee.dao.LockDao;
import com.github.arangobee.exception.ArangobeeConnectionException;
import com.github.arangobee.exception.ArangobeeLockException;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEntryDao {
    private static final Logger logger = LoggerFactory.getLogger((String)"Arangobee dao");
    private ArangoDatabase arangoDatabase;
    private ChangeEntryIndexDao indexDao;
    private String changelogCollectionName;
    private boolean waitForLock;
    private long changeLogLockWaitTime;
    private long changeLogLockPollRate;
    private boolean throwExceptionIfCannotObtainLock;
    private LockDao lockDao;

    public ChangeEntryDao(String changelogCollectionName, String lockCollectionName, boolean waitForLock, long changeLogLockWaitTime, long changeLogLockPollRate, boolean throwExceptionIfCannotObtainLock) {
        this.indexDao = new ChangeEntryIndexDao(changelogCollectionName);
        this.lockDao = new LockDao(lockCollectionName);
        this.changelogCollectionName = changelogCollectionName;
        this.waitForLock = waitForLock;
        this.changeLogLockWaitTime = changeLogLockWaitTime;
        this.changeLogLockPollRate = changeLogLockPollRate;
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
    }

    public ArangoDatabase getArangoDatabase() {
        return this.arangoDatabase;
    }

    public ArangoDatabase connectDb(ArangoDatabase arangoDatabase) {
        this.arangoDatabase = arangoDatabase;
        this.ensureChangeLogCollectionIndex(arangoDatabase, this.changelogCollectionName);
        this.initializeLock();
        return arangoDatabase;
    }

    public String acquireProcessLock() throws ArangobeeConnectionException, ArangobeeLockException {
        this.verifyDbConnection();
        String acquired = this.lockDao.acquireLock(this.getArangoDatabase());
        if (acquired == null && this.waitForLock) {
            long timeToGiveUp = new Date().getTime() + this.changeLogLockWaitTime * 1000L * 60L;
            while (acquired == null && new Date().getTime() < timeToGiveUp) {
                acquired = this.lockDao.acquireLock(this.getArangoDatabase());
                if (acquired != null) continue;
                logger.info("Waiting for changelog lock....");
                try {
                    Thread.sleep(this.changeLogLockPollRate * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (acquired == null && this.throwExceptionIfCannotObtainLock) {
            logger.info("Arangobee did not acquire process lock. Throwing exception.");
            throw new ArangobeeLockException("Could not acquire process lock");
        }
        return acquired;
    }

    public void releaseProcessLock(String lock) throws ArangobeeConnectionException {
        this.verifyDbConnection();
        this.lockDao.releaseLock(this.getArangoDatabase(), lock);
    }

    public boolean isProccessLockHeld() throws ArangobeeConnectionException {
        this.verifyDbConnection();
        return this.lockDao.isLockHeld(this.getArangoDatabase());
    }

    public boolean isNewChange(ChangeEntry changeEntry) throws ArangobeeConnectionException {
        this.verifyDbConnection();
        return !this.getArangoDatabase().query("FOR t IN " + this.changelogCollectionName + " FILTER t.changeId == @changeId && t.author == @author RETURN t", BaseDocument.class, (Map)ImmutableMap.of((Object)"changeId", (Object)changeEntry.getChangeId(), (Object)"author", (Object)changeEntry.getAuthor()), null).hasNext();
    }

    public void save(ChangeEntry changeEntry) throws ArangobeeConnectionException {
        this.verifyDbConnection();
        ArangoCollection arangobeeLog = this.getArangoDatabase().collection(this.changelogCollectionName);
        arangobeeLog.insertDocument((Object)changeEntry.buildFullDBObject());
    }

    private void verifyDbConnection() throws ArangobeeConnectionException {
        if (this.getArangoDatabase() == null) {
            throw new ArangobeeConnectionException("Database is not connected. Arangobee has thrown an unexpected error", new NullPointerException());
        }
    }

    private void ensureChangeLogCollectionIndex(ArangoDatabase arangoTemplate, String collectionName) {
        ArangoCollection collection = arangoTemplate.collection(collectionName);
        if (!collection.exists()) {
            arangoTemplate.createCollection(collectionName);
        }
        this.indexDao.createRequiredUniqueIndex(collection);
    }

    public void close() {
    }

    private void initializeLock() {
        this.lockDao.intitializeLock(this.arangoDatabase);
    }

    public void setIndexDao(ChangeEntryIndexDao changeEntryIndexDao) {
        this.indexDao = changeEntryIndexDao;
    }

    void setLockDao(LockDao lockDao) {
        this.lockDao = lockDao;
    }

    public void setChangelogCollectionName(String changelogCollectionName) {
        this.changelogCollectionName = changelogCollectionName;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockDao.setLockCollectionName(lockCollectionName);
    }

    public boolean isWaitForLock() {
        return this.waitForLock;
    }

    public void setWaitForLock(boolean waitForLock) {
        this.waitForLock = waitForLock;
    }

    public long getChangeLogLockWaitTime() {
        return this.changeLogLockWaitTime;
    }

    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockWaitTime = changeLogLockWaitTime;
    }

    public long getChangeLogLockPollRate() {
        return this.changeLogLockPollRate;
    }

    public void setChangeLogLockPollRate(long changeLogLockPollRate) {
        this.changeLogLockPollRate = changeLogLockPollRate;
    }

    public boolean isThrowExceptionIfCannotObtainLock() {
        return this.throwExceptionIfCannotObtainLock;
    }

    public void setThrowExceptionIfCannotObtainLock(boolean throwExceptionIfCannotObtainLock) {
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
    }
}

