/*
 * Decompiled with CFR 0.152.
 */
package com.github.arangobee.dao;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.BaseDocument;

public class LockDao {
    private static final String LOCK_ENTRY_KEY_VAL = "LOCK";
    private String lockCollectionName;

    public LockDao(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }

    public void intitializeLock(ArangoDatabase arangoDatabase) {
        this.createCollectionAndUniqueIndexIfNotExists(arangoDatabase);
    }

    private void createCollectionAndUniqueIndexIfNotExists(ArangoDatabase arangoDatabase) {
        ArangoCollection collection = arangoDatabase.collection(this.lockCollectionName);
        if (!collection.exists()) {
            arangoDatabase.createCollection(this.lockCollectionName);
        }
    }

    public String acquireLock(ArangoDatabase arangoDatabase) {
        BaseDocument insertObj = new BaseDocument();
        insertObj.setKey(LOCK_ENTRY_KEY_VAL);
        insertObj.addAttribute("status", (Object)"LOCK_HELD");
        try {
            return arangoDatabase.collection(this.lockCollectionName).insertDocument((Object)insertObj).getKey();
        }
        catch (ArangoDBException ex) {
            return null;
        }
    }

    public void releaseLock(ArangoDatabase arangoDatabase, String lock) {
        arangoDatabase.collection(this.lockCollectionName).deleteDocument(lock);
    }

    public boolean isLockHeld(ArangoDatabase arangoDatabase) {
        return arangoDatabase.collection(this.lockCollectionName).count().getCount() == 1L;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }
}

