/*
 * Decompiled with CFR 0.152.
 */
package com.github.mongobee.dao;

import com.github.mongobee.changeset.ChangeEntry;
import com.github.mongobee.dao.ChangeEntryIndexDao;
import com.github.mongobee.dao.LockDao;
import com.github.mongobee.exception.MongobeeConfigurationException;
import com.github.mongobee.exception.MongobeeConnectionException;
import com.github.mongobee.exception.MongobeeLockException;
import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ChangeEntryDao {
    private static final Logger logger = LoggerFactory.getLogger((String)"Mongobee dao");
    private MongoDatabase mongoDatabase;
    private DB db;
    private MongoClient mongoClient;
    private ChangeEntryIndexDao indexDao;
    private String changelogCollectionName;
    private boolean waitForLock;
    private long changeLogLockWaitTime;
    private long changeLogLockPollRate;
    private boolean throwExceptionIfCannotObtainLock;
    private LockDao lockDao;

    public ChangeEntryDao(String changelogCollectionName, String lockCollectionName, boolean waitForLock, long changeLogLockWaitTime, long changeLogLockPollRate, boolean throwExceptionIfCannotObtainLock) {
        this.indexDao = new ChangeEntryIndexDao(changelogCollectionName);
        this.lockDao = new LockDao(lockCollectionName);
        this.changelogCollectionName = changelogCollectionName;
        this.waitForLock = waitForLock;
        this.changeLogLockWaitTime = changeLogLockWaitTime;
        this.changeLogLockPollRate = changeLogLockPollRate;
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public DB getDb() {
        return this.db;
    }

    public MongoDatabase connectMongoDb(MongoClient mongo, String dbName) throws MongobeeConfigurationException {
        if (!StringUtils.hasText((String)dbName)) {
            throw new MongobeeConfigurationException("DB name is not set. Should be defined in MongoDB URI or via setter");
        }
        this.mongoClient = mongo;
        this.db = mongo.getDB(dbName);
        this.mongoDatabase = mongo.getDatabase(dbName);
        this.ensureChangeLogCollectionIndex((MongoCollection<Document>)this.mongoDatabase.getCollection(this.changelogCollectionName));
        this.initializeLock();
        return this.mongoDatabase;
    }

    public MongoDatabase connectMongoDb(MongoClientURI mongoClientURI, String dbName) throws MongobeeConfigurationException, MongobeeConnectionException {
        MongoClient mongoClient = new MongoClient(mongoClientURI);
        String database = !StringUtils.hasText((String)dbName) ? mongoClientURI.getDatabase() : dbName;
        return this.connectMongoDb(mongoClient, database);
    }

    public boolean acquireProcessLock() throws MongobeeConnectionException, MongobeeLockException {
        this.verifyDbConnection();
        boolean acquired = this.lockDao.acquireLock(this.getMongoDatabase());
        if (!acquired && this.waitForLock) {
            long timeToGiveUp = new Date().getTime() + this.changeLogLockWaitTime * 1000L * 60L;
            while (!acquired && new Date().getTime() < timeToGiveUp) {
                acquired = this.lockDao.acquireLock(this.getMongoDatabase());
                if (acquired) continue;
                logger.info("Waiting for changelog lock....");
                try {
                    Thread.sleep(this.changeLogLockPollRate * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!acquired && this.throwExceptionIfCannotObtainLock) {
            logger.info("Mongobee did not acquire process lock. Throwing exception.");
            throw new MongobeeLockException("Could not acquire process lock");
        }
        return acquired;
    }

    public void releaseProcessLock() throws MongobeeConnectionException {
        this.verifyDbConnection();
        this.lockDao.releaseLock(this.getMongoDatabase());
    }

    public boolean isProccessLockHeld() throws MongobeeConnectionException {
        this.verifyDbConnection();
        return this.lockDao.isLockHeld(this.getMongoDatabase());
    }

    public boolean isNewChange(ChangeEntry changeEntry) throws MongobeeConnectionException {
        this.verifyDbConnection();
        MongoCollection mongobeeChangeLog = this.getMongoDatabase().getCollection(this.changelogCollectionName);
        Document entry = (Document)mongobeeChangeLog.find((Bson)changeEntry.buildSearchQueryDBObject()).first();
        return entry == null;
    }

    public void save(ChangeEntry changeEntry) throws MongobeeConnectionException {
        this.verifyDbConnection();
        MongoCollection mongobeeLog = this.getMongoDatabase().getCollection(this.changelogCollectionName);
        mongobeeLog.insertOne((Object)changeEntry.buildFullDBObject());
    }

    private void verifyDbConnection() throws MongobeeConnectionException {
        if (this.getMongoDatabase() == null) {
            throw new MongobeeConnectionException("Database is not connected. Mongobee has thrown an unexpected error", new NullPointerException());
        }
    }

    private void ensureChangeLogCollectionIndex(MongoCollection<Document> collection) {
        Document index = this.indexDao.findRequiredChangeAndAuthorIndex(this.mongoDatabase);
        if (index == null) {
            this.indexDao.createRequiredUniqueIndex(collection);
            logger.debug("Index in collection " + this.changelogCollectionName + " was created");
        } else if (!this.indexDao.isUnique(index)) {
            this.indexDao.dropIndex(collection, index);
            this.indexDao.createRequiredUniqueIndex(collection);
            logger.debug("Index in collection " + this.changelogCollectionName + " was recreated");
        }
    }

    public void close() {
        this.mongoClient.close();
    }

    private void initializeLock() {
        this.lockDao.intitializeLock(this.mongoDatabase);
    }

    public void setIndexDao(ChangeEntryIndexDao changeEntryIndexDao) {
        this.indexDao = changeEntryIndexDao;
    }

    void setLockDao(LockDao lockDao) {
        this.lockDao = lockDao;
    }

    public void setChangelogCollectionName(String changelogCollectionName) {
        this.indexDao.setChangelogCollectionName(changelogCollectionName);
        this.changelogCollectionName = changelogCollectionName;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockDao.setLockCollectionName(lockCollectionName);
    }

    public boolean isWaitForLock() {
        return this.waitForLock;
    }

    public void setWaitForLock(boolean waitForLock) {
        this.waitForLock = waitForLock;
    }

    public long getChangeLogLockWaitTime() {
        return this.changeLogLockWaitTime;
    }

    public void setChangeLogLockWaitTime(long changeLogLockWaitTime) {
        this.changeLogLockWaitTime = changeLogLockWaitTime;
    }

    public long getChangeLogLockPollRate() {
        return this.changeLogLockPollRate;
    }

    public void setChangeLogLockPollRate(long changeLogLockPollRate) {
        this.changeLogLockPollRate = changeLogLockPollRate;
    }

    public boolean isThrowExceptionIfCannotObtainLock() {
        return this.throwExceptionIfCannotObtainLock;
    }

    public void setThrowExceptionIfCannotObtainLock(boolean throwExceptionIfCannotObtainLock) {
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
    }
}

