/*
 * Decompiled with CFR 0.152.
 */
package com.github.mongobee.dao;

import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ChangeEntryIndexDao {
    private String changelogCollectionName;

    public ChangeEntryIndexDao(String changelogCollectionName) {
        this.changelogCollectionName = changelogCollectionName;
    }

    public void createRequiredUniqueIndex(MongoCollection<Document> collection) {
        collection.createIndex((Bson)new Document().append("changeId", (Object)1).append("author", (Object)1), new IndexOptions().unique(true));
    }

    public Document findRequiredChangeAndAuthorIndex(MongoDatabase db) {
        ListIndexesIterable indexes = db.getCollection(this.changelogCollectionName).listIndexes();
        if (indexes == null) {
            return null;
        }
        for (Document indexDefinition : indexes) {
            Document key = (Document)indexDefinition.get((Object)"key", Document.class);
            if (key.get((Object)"changeId") == null || key.get((Object)"author") == null) continue;
            return indexDefinition;
        }
        return null;
    }

    public boolean isUnique(Document index) {
        Object unique = index.get((Object)"unique");
        if (unique != null && unique instanceof Boolean) {
            return (Boolean)unique;
        }
        return false;
    }

    public void dropIndex(MongoCollection<Document> collection, Document index) {
        collection.dropIndex(index.get((Object)"name").toString());
    }

    public void setChangelogCollectionName(String changelogCollectionName) {
        this.changelogCollectionName = changelogCollectionName;
    }
}

