/*
 * Decompiled with CFR 0.152.
 */
package com.github.mongobee.dao;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockDao {
    private static final Logger logger = LoggerFactory.getLogger(LockDao.class);
    private static final String KEY_PROP_NAME = "key";
    private static final int INDEX_SORT_ASC = 1;
    private static final String LOCK_ENTRY_KEY_VAL = "LOCK";
    private String lockCollectionName;

    public LockDao(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }

    public void intitializeLock(MongoDatabase db) {
        this.createCollectionAndUniqueIndexIfNotExists(db);
    }

    private void createCollectionAndUniqueIndexIfNotExists(MongoDatabase db) {
        Document indexKeys = new Document(KEY_PROP_NAME, (Object)1);
        IndexOptions indexOptions = new IndexOptions().unique(true).name("mongobeelock_key_idx");
        db.getCollection(this.lockCollectionName).createIndex((Bson)indexKeys, indexOptions);
    }

    public boolean acquireLock(MongoDatabase db) {
        Document insertObj = new Document(KEY_PROP_NAME, (Object)LOCK_ENTRY_KEY_VAL).append("status", (Object)"LOCK_HELD");
        try {
            db.getCollection(this.lockCollectionName).insertOne((Object)insertObj);
        }
        catch (MongoWriteException ex) {
            if (ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                logger.warn("Duplicate key exception while acquireLock. Probably the lock has been already acquired.");
            }
            return false;
        }
        return true;
    }

    public void releaseLock(MongoDatabase db) {
        db.getCollection(this.lockCollectionName).deleteMany((Bson)new Document(KEY_PROP_NAME, (Object)LOCK_ENTRY_KEY_VAL));
    }

    public boolean isLockHeld(MongoDatabase db) {
        return db.getCollection(this.lockCollectionName).count() == 1L;
    }

    public void setLockCollectionName(String lockCollectionName) {
        this.lockCollectionName = lockCollectionName;
    }
}

