/*
 * Decompiled with CFR 0.152.
 */
package com.github.mongobee.utils;

import com.github.mongobee.changeset.ChangeEntry;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.github.mongobee.exception.MongobeeChangeSetException;
import com.github.mongobee.utils.ChangeLogComparator;
import com.github.mongobee.utils.ChangeSetComparator;
import com.github.mongobee.utils.ClassUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

public class ChangeService {
    private static final String DEFAULT_PROFILE = "default";
    private final String changeLogsBasePackage;
    private final List<String> activeProfiles;

    public ChangeService(String changeLogsBasePackage) {
        this(changeLogsBasePackage, null);
    }

    public ChangeService(String changeLogsBasePackage, Environment environment) {
        this.changeLogsBasePackage = changeLogsBasePackage;
        this.activeProfiles = environment != null && environment.getActiveProfiles() != null && environment.getActiveProfiles().length > 0 ? Arrays.asList(environment.getActiveProfiles()) : Arrays.asList(DEFAULT_PROFILE);
    }

    public List<Class<?>> fetchChangeLogs() {
        Reflections reflections = new Reflections(this.changeLogsBasePackage, new Scanner[0]);
        Set changeLogs = reflections.getTypesAnnotatedWith(ChangeLog.class);
        List<Class<?>> filteredChangeLogs = this.filterByActiveProfiles(changeLogs);
        Collections.sort(filteredChangeLogs, new ChangeLogComparator());
        return filteredChangeLogs;
    }

    public List<Method> fetchChangeSets(Class<?> type) throws MongobeeChangeSetException {
        List<Method> changeSets = this.filterChangeSetAnnotation(Arrays.asList(type.getDeclaredMethods()));
        List<Method> filteredChangeSets = this.filterByActiveProfiles(changeSets);
        Collections.sort(filteredChangeSets, new ChangeSetComparator());
        return filteredChangeSets;
    }

    public boolean isRunAlwaysChangeSet(Method changesetMethod) {
        if (changesetMethod.isAnnotationPresent(ChangeSet.class)) {
            ChangeSet annotation = changesetMethod.getAnnotation(ChangeSet.class);
            return annotation.runAlways();
        }
        return false;
    }

    public ChangeEntry createChangeEntry(Method changesetMethod) {
        if (changesetMethod.isAnnotationPresent(ChangeSet.class)) {
            ChangeSet annotation = changesetMethod.getAnnotation(ChangeSet.class);
            return new ChangeEntry(annotation.id(), annotation.author(), new Date(), changesetMethod.getDeclaringClass().getName(), changesetMethod.getName());
        }
        return null;
    }

    private boolean matchesActiveSpringProfile(AnnotatedElement element) {
        if (!ClassUtils.isPresent("org.springframework.context.annotation.Profile", null)) {
            return true;
        }
        if (!element.isAnnotationPresent(Profile.class)) {
            return true;
        }
        List<String> profiles = Arrays.asList(element.getAnnotation(Profile.class).value());
        for (String profile : profiles) {
            if (!(profile != null && profile.length() > 0 && profile.charAt(0) == '!' ? !this.activeProfiles.contains(profile.substring(1)) : this.activeProfiles.contains(profile))) continue;
            return true;
        }
        return false;
    }

    private List<?> filterByActiveProfiles(Collection<? extends AnnotatedElement> annotated) {
        ArrayList<AnnotatedElement> filtered = new ArrayList<AnnotatedElement>();
        for (AnnotatedElement annotatedElement : annotated) {
            if (!this.matchesActiveSpringProfile(annotatedElement)) continue;
            filtered.add(annotatedElement);
        }
        return filtered;
    }

    private List<Method> filterChangeSetAnnotation(List<Method> allMethods) throws MongobeeChangeSetException {
        HashSet<String> changeSetIds = new HashSet<String>();
        ArrayList<Method> changesetMethods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!method.isAnnotationPresent(ChangeSet.class)) continue;
            String id = method.getAnnotation(ChangeSet.class).id();
            if (changeSetIds.contains(id)) {
                throw new MongobeeChangeSetException(String.format("Duplicated changeset id found: '%s'", id));
            }
            changeSetIds.add(id);
            changesetMethods.add(method);
        }
        return changesetMethods;
    }
}

