/*
 * Decompiled with CFR 0.152.
 */
package com.celarli.commons.vfs.provider.google;

import com.celarli.commons.vfs.provider.google.ClientType;
import com.celarli.commons.vfs.provider.google.GcsFileSystemConfigBuilder;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.vfs2.FileSystemOptions;

public class GcsClientFactory {
    private static final String INVALID_CLIENT_TYPE = "No suitable client type found to create storage client";
    private static final String CREDENTIAL_NOT_FOUND = "Credential not found";

    public static Storage getClient(FileSystemOptions fileSystemOptions) {
        Integer type = GcsFileSystemConfigBuilder.getInstance().getClientType(fileSystemOptions);
        Optional<ClientType> optional = ClientType.getByType(type);
        ClientType clientType = optional.orElseThrow(() -> new RuntimeException(INVALID_CLIENT_TYPE));
        switch (clientType) {
            case STORAGE_ACCOUNT: {
                byte[] bytes = GcsFileSystemConfigBuilder.getInstance().getKey(fileSystemOptions);
                if (bytes == null) {
                    throw new RuntimeException(CREDENTIAL_NOT_FOUND);
                }
                try {
                    GoogleCredentials credentials = GoogleCredentials.fromStream((InputStream)new ByteArrayInputStream(bytes));
                    String hostname = GcsFileSystemConfigBuilder.getInstance().getHostname(fileSystemOptions);
                    if (hostname != null) {
                        return (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).setHost(hostname)).build().getService();
                    }
                    return (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)credentials)).build().getService();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe.getMessage());
                }
            }
            case COMPUTE_ENGINE: {
                ComputeEngineCredentials computeEngineCredentials = ComputeEngineCredentials.create();
                return (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)computeEngineCredentials)).build().getService();
            }
            case APPLICATION: {
                return (Storage)StorageOptions.getDefaultInstance().getService();
            }
        }
        throw new RuntimeException(INVALID_CLIENT_TYPE);
    }
}

