/*
 * Decompiled with CFR 0.152.
 */
package com.celarli.commons.vfs.provider.google;

import com.celarli.commons.vfs.provider.google.GcsFileName;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class GcsFileNameParser
extends AbstractFileNameParser {
    private static final GcsFileNameParser INSTANCE = new GcsFileNameParser();

    public static GcsFileNameParser getInstance() {
        return INSTANCE;
    }

    private GcsFileNameParser() {
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder pathStringBuilder = new StringBuilder();
        String scheme = UriParser.extractScheme((String)uri, (StringBuilder)pathStringBuilder);
        UriParser.fixSeparators((StringBuilder)pathStringBuilder);
        FileType fileType = UriParser.normalisePath((StringBuilder)pathStringBuilder);
        String bucketName = UriParser.extractFirstElement((StringBuilder)pathStringBuilder);
        return new GcsFileName(scheme, bucketName, pathStringBuilder.toString(), fileType);
    }
}

