/*
 * Decompiled with CFR 0.152.
 */
package com.celarli.commons.vfs.provider.google;

import com.celarli.commons.vfs.provider.google.GcsFileName;
import com.celarli.commons.vfs.provider.google.GcsFileSystem;
import com.celarli.commons.vfs.provider.google.GcsFileSystemConfigBuilder;
import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsFileObject
extends AbstractFileObject<GcsFileSystem> {
    private static final Logger log = LoggerFactory.getLogger(GcsFileObject.class);
    public static int COPY_BUFFER_SIZE = 0x2000000;
    public static final String PATH_DELIMITER = "/";
    private final Storage storage;
    private Blob currentBlob = null;
    private static Tika tika = new Tika();

    GcsFileObject(@Nonnull AbstractFileName name, @Nonnull GcsFileSystem fs, @Nonnull Storage storage) {
        super(name, (AbstractFileSystem)fs);
        this.storage = storage;
    }

    protected boolean doSetLastModifiedTime(long modtime) {
        return true;
    }

    @Nonnull
    protected FileType doGetType() {
        Blob blob;
        GcsFileName fileName = (GcsFileName)this.getName();
        if (fileName != null && fileName.getType() == FileType.FOLDER) {
            return FileType.FOLDER;
        }
        Bucket bucket = this.storage.get(fileName.getBucket(), new Storage.BucketGetOption[0]);
        if (bucket == null || !bucket.exists(new Bucket.BucketSourceOption[0])) {
            throw new IllegalArgumentException(String.format("Bucket %s does not exists", fileName.getBucket()));
        }
        String path = fileName.getPath();
        if (!path.equals(PATH_DELIMITER) && path.startsWith(PATH_DELIMITER)) {
            path = path.substring(1);
        }
        if ((blob = bucket.get(path, new Storage.BlobGetOption[0])) != null && blob.exists(new Blob.BlobSourceOption[0])) {
            log.debug(String.format("File :%s exists on bucket", this.getName()));
            return FileType.FILE;
        }
        String url = this.computePostfix(fileName);
        log.debug(String.format("File does not :%s exists on bucket try to see if it's a directory", this.getName()));
        if (url.equals(PATH_DELIMITER)) {
            return FileType.FOLDER;
        }
        if (url.startsWith(PATH_DELIMITER)) {
            url = url.substring(1);
        }
        log.debug(String.format("listing directory :%s", url));
        Page blobs = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)url)});
        if (blobs.getValues().iterator().hasNext()) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    @Nonnull
    protected String[] doListChildren() throws Exception {
        log.debug(String.format("Listing directory below:%s", this.getName().toString()));
        GcsFileName fileName = (GcsFileName)this.getName();
        Bucket bucket = this.storage.get(fileName.getBucket(), new Storage.BucketGetOption[0]);
        if (bucket == null || !bucket.exists(new Bucket.BucketSourceOption[0])) {
            throw new IllegalArgumentException(String.format("Bucket %s does not exists", fileName.getBucket()));
        }
        String path = this.computePostfix(fileName);
        if (path.startsWith(PATH_DELIMITER)) {
            path = path.substring(1);
        }
        Page blobs = bucket.list(new Storage.BlobListOption[]{Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.prefix((String)path)});
        ArrayList<String> children = new ArrayList<String>();
        for (Blob blob : blobs.iterateAll()) {
            String name = blob.getName();
            if (name.equalsIgnoreCase(path)) continue;
            String strippedName = name.substring(path.length());
            children.add(strippedName);
        }
        String[] childrenArray = new String[children.size()];
        children.toArray(childrenArray);
        return childrenArray;
    }

    public boolean exists() throws FileSystemException {
        try {
            FileType type = this.doGetType();
            return FileType.IMAGINARY != type;
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    @Nonnull
    private String computePostfix(@Nonnull GcsFileName fileName) {
        String postfix = fileName.getPath();
        if (!postfix.endsWith(PATH_DELIMITER)) {
            postfix = postfix + PATH_DELIMITER;
        }
        return postfix;
    }

    protected long doGetContentSize() {
        return this.currentBlob.getSize();
    }

    @Nonnull
    protected InputStream doGetInputStream() {
        ReadChannel readChannel = this.storage.reader(this.currentBlob.getBlobId(), new Storage.BlobSourceOption[0]);
        readChannel.setChunkSize(COPY_BUFFER_SIZE);
        return Channels.newInputStream((ReadableByteChannel)readChannel);
    }

    @Nonnull
    protected OutputStream doGetOutputStream(boolean bAppend) {
        this.createBlob(true);
        String cmkId = this.getCmkId();
        WriteChannel wc = cmkId != null ? this.currentBlob.writer(new Storage.BlobWriteOption[]{Storage.BlobWriteOption.disableGzipContent(), Storage.BlobWriteOption.kmsKeyName((String)cmkId)}) : this.currentBlob.writer(new Storage.BlobWriteOption[]{Storage.BlobWriteOption.disableGzipContent()});
        wc.setChunkSize(COPY_BUFFER_SIZE);
        return Channels.newOutputStream((WritableByteChannel)wc);
    }

    protected void doCreateFolder() {
        log.info("doCreateFolder() called.");
    }

    public void createFolder() {
        log.debug("createFolder() called.");
    }

    protected void doAttach() {
        GcsFileName fileName = (GcsFileName)this.getName();
        Bucket bucket = this.storage.get(fileName.getBucket(), new Storage.BucketGetOption[0]);
        if (bucket == null || !bucket.exists(new Bucket.BucketSourceOption[0])) {
            throw new IllegalArgumentException(String.format("Bucket %s does not exists", fileName.getBucket()));
        }
        String path = fileName.getPath();
        if (!path.equals(PATH_DELIMITER) && path.startsWith(PATH_DELIMITER)) {
            path = path.substring(1);
        }
        this.currentBlob = bucket.get(path, new Storage.BlobGetOption[0]);
    }

    protected void doDelete() {
        this.doAttach();
        if (this.currentBlob != null) {
            this.currentBlob.delete(new Blob.BlobSourceOption[0]);
        }
    }

    private void createBlob(boolean detectContentType) {
        BlobInfo blobInfo;
        GcsFileName fileName = (GcsFileName)this.getName();
        String path = fileName.getPath();
        if (fileName.getType() == FileType.FOLDER) {
            path = this.computePostfix(fileName);
        }
        if (!path.equals(PATH_DELIMITER) && path.startsWith(PATH_DELIMITER)) {
            path = path.substring(1);
        }
        if (detectContentType) {
            String baseName = this.getName().getBaseName();
            String contentType = tika.detect(baseName);
            blobInfo = BlobInfo.newBuilder((String)fileName.getBucket(), (String)path).setContentType(contentType).build();
        } else {
            blobInfo = BlobInfo.newBuilder((String)fileName.getBucket(), (String)path).build();
        }
        String cmkId = this.getCmkId();
        this.currentBlob = cmkId != null ? this.storage.create(blobInfo, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.kmsKeyName((String)cmkId)}) : this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
    }

    public FileObject[] getChildren() throws FileSystemException {
        try {
            if (this.getType().hasContent()) {
                throw new FileNotFolderException((Object)this.getName());
            }
        }
        catch (Exception ex) {
            throw new FileNotFolderException((Object)this.getName(), (Throwable)ex);
        }
        return super.getChildren();
    }

    protected long doGetLastModifiedTime() throws Exception {
        if (this.currentBlob != null) {
            return this.currentBlob.getUpdateTime();
        }
        return super.doGetLastModifiedTime();
    }

    public void copyFrom(FileObject file, FileSelector selector) throws FileSystemException {
        this.copyFrom(file, selector, null);
    }

    public void copyFrom(FileObject file, FileSelector selector, CopyStreamListener copyStreamListener) throws FileSystemException {
        if (!file.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", (Object)file);
        }
        if (this.canCopyServerSide(file)) {
            ArrayList files = new ArrayList();
            file.findFiles(selector, false, files);
            int numFiles = files.size();
            for (int i = 0; i < numFiles; ++i) {
                GcsFileObject srcFile = (GcsFileObject)((Object)files.get(i));
                String relPath = file.getName().getRelativeName(srcFile.getName());
                GcsFileObject destFile = (GcsFileObject)this.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
                if (destFile.exists() && destFile.getType() != srcFile.getType()) {
                    destFile.delete(Selectors.SELECT_ALL);
                }
                try {
                    if (srcFile.getType().hasContent()) {
                        GcsFileName destFileName = (GcsFileName)destFile.getName();
                        String path = destFileName.getPath();
                        if (!path.equals(PATH_DELIMITER) && path.startsWith(PATH_DELIMITER)) {
                            path = path.substring(1);
                        }
                        String bucket = destFileName.getBucket();
                        srcFile.attachIfRequired();
                        CopyWriter copyWriter = srcFile.currentBlob.copyTo(BlobId.of((String)bucket, (String)path), new Blob.BlobSourceOption[0]);
                        try {
                            destFile.injectType(destFile.doGetType());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        destFile.currentBlob = copyWriter.getResult();
                        continue;
                    }
                    if (!srcFile.getType().hasChildren()) continue;
                    destFile.createFolder();
                    continue;
                }
                catch (IOException e) {
                    throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{srcFile, destFile});
                }
            }
        } else {
            this.streamCopy(file, selector, copyStreamListener);
            this.attachIfRequired();
        }
    }

    private void streamCopy(FileObject file, FileSelector selector, CopyStreamListener copyStreamListener) throws FileSystemException {
        ArrayList files = new ArrayList();
        file.findFiles(selector, false, files);
        int numFiles = files.size();
        for (int i = 0; i < numFiles; ++i) {
            FileObject srcFile = (FileObject)files.get(i);
            String relPath = file.getName().getRelativeName(srcFile.getName());
            FileObject destFile = this.resolveFile(relPath, NameScope.DESCENDENT_OR_SELF);
            if (destFile.exists() && destFile.getType() != srcFile.getType()) {
                destFile.delete(Selectors.SELECT_ALL);
            }
            try {
                if (srcFile.getType().hasContent()) {
                    try (InputStream inputStream = srcFile.getContent().getInputStream();
                         OutputStream outputStream = destFile.getContent().getOutputStream();){
                        Util.copyStream((InputStream)new BufferedInputStream(inputStream, COPY_BUFFER_SIZE), (OutputStream)outputStream, (int)COPY_BUFFER_SIZE, (long)srcFile.getContent().getSize(), (CopyStreamListener)copyStreamListener);
                        continue;
                    }
                }
                if (!srcFile.getType().hasChildren()) continue;
                destFile.createFolder();
                continue;
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/copy-file.error", (Throwable)e, new Object[]{srcFile, destFile});
            }
        }
    }

    private boolean canCopyServerSide(FileObject sourceFileObject) {
        if (sourceFileObject instanceof GcsFileObject) {
            GcsFileObject gcsFileObject = (GcsFileObject)sourceFileObject;
            Credentials sourceCredential = null;
            if (gcsFileObject.storage != null && gcsFileObject.storage.getOptions() != null) {
                sourceCredential = ((StorageOptions)gcsFileObject.storage.getOptions()).getCredentials();
            }
            Credentials destinationCredential = null;
            if (this.storage != null && this.storage.getOptions() != null) {
                destinationCredential = ((StorageOptions)this.storage.getOptions()).getCredentials();
            }
            if (sourceCredential != null && destinationCredential != null && sourceCredential.equals(destinationCredential)) {
                return true;
            }
        }
        return false;
    }

    public boolean canRenameTo(FileObject fileObject) {
        return false;
    }

    public URL signedURL(long duration) {
        this.attachIfRequired();
        if (Objects.nonNull(this.currentBlob)) {
            return this.currentBlob.signUrl(duration, TimeUnit.SECONDS, new Storage.SignUrlOption[0]);
        }
        return null;
    }

    private void attachIfRequired() {
        try {
            if (Objects.isNull(this.currentBlob)) {
                this.doAttach();
            }
        }
        catch (Exception e) {
            log.error("Failed to attach", (Throwable)e);
        }
    }

    private String getCmkId() {
        FileSystemOptions options = this.getFileSystem().getFileSystemOptions();
        if (options != null) {
            return GcsFileSystemConfigBuilder.getInstance().getCmkId(options);
        }
        return null;
    }
}

