/*
 * Decompiled with CFR 0.152.
 */
package com.celarli.commons.vfs.provider.google;

import com.celarli.commons.vfs.provider.google.GcsClientFactory;
import com.celarli.commons.vfs.provider.google.GcsFileNameParser;
import com.celarli.commons.vfs.provider.google.GcsFileSystem;
import com.google.cloud.storage.Storage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileNameParser;

public class GcsFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.APPEND_CONTENT, Capability.URI, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ, Capability.DIRECTORY_READ_CONTENT, Capability.LIST_CHILDREN, Capability.LAST_MODIFIED, Capability.GET_LAST_MODIFIED, Capability.CREATE, Capability.DELETE));

    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) {
        Storage storage = GcsClientFactory.getClient(fileSystemOptions);
        return new GcsFileSystem(fileName, fileSystemOptions, storage);
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    public GcsFileProvider() {
        this.setFileNameParser((FileNameParser)GcsFileNameParser.getInstance());
    }
}

