/*
 * Decompiled with CFR 0.152.
 */
package com.celarli.commons.vfs.provider.google;

import com.celarli.commons.vfs.provider.google.GcsFileObject;
import com.celarli.commons.vfs.provider.google.GcsFileProvider;
import com.google.cloud.storage.Storage;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public class GcsFileSystem
extends AbstractFileSystem {
    private final Storage storage;

    GcsFileSystem(@Nonnull FileName rootName, @Nullable FileSystemOptions fileSystemOptions, @Nonnull Storage storage) {
        super(rootName, null, fileSystemOptions);
        this.storage = storage;
    }

    @Nonnull
    protected FileObject createFile(@Nonnull AbstractFileName abstractFileName) {
        return new GcsFileObject(abstractFileName, this, this.storage);
    }

    protected void addCapabilities(@Nonnull Collection<Capability> caps) {
        caps.addAll(GcsFileProvider.capabilities);
    }
}

