/*
 * Decompiled with CFR 0.152.
 */
package com.github.damiansheldon.aop;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.web.context.request.WebRequest;

public abstract class AbstractStackTraceLogAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ErrorAttributes errorAttributes;

    public AbstractStackTraceLogAspect(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    protected void stackTraceLogIfNecessary(WebRequest webRequest, Map<String, Object> retVal) {
        if (this.logger.isWarnEnabled()) {
            Throwable error;
            Map<String, Object> logResult = retVal;
            if (!retVal.containsKey("trace") && (error = this.errorAttributes.getError(webRequest)) != null) {
                StringWriter stackTrace = new StringWriter();
                error.printStackTrace(new PrintWriter(stackTrace));
                stackTrace.flush();
                logResult = new LinkedHashMap<String, Object>(retVal);
                logResult.put("trace", stackTrace.toString());
            }
            this.logger.warn(logResult.toString());
        }
    }
}

