/*
 * Decompiled with CFR 0.152.
 */
package com.github.damiansheldon.jdbc.support.incrementer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.incrementer.AbstractColumnMaxValueIncrementer;

public class MySQLMultipleTableMaxValueIncrementer
extends AbstractColumnMaxValueIncrementer {
    public static final String DEFAULT_INCREMENTER_NAME = "tab_sequence";
    public static final String DEFAULT_COLUMN_NAME_OF_TABLE = "tab";
    private long nextId = 0L;
    private long maxId = 0L;
    private boolean useNewConnection = true;
    private String columnNameOfTable;
    private String columnValueOfTable;

    public MySQLMultipleTableMaxValueIncrementer(DataSource dataSource, String incrementerName, String columnNameOfTable, String columnValueOfTable, String columnName) {
        super(dataSource, incrementerName, columnName);
        assert (columnNameOfTable != null);
        assert (columnValueOfTable.length() > 0);
        this.columnNameOfTable = columnNameOfTable;
        assert (columnValueOfTable != null);
        assert (columnValueOfTable.length() > 0);
        this.columnValueOfTable = columnValueOfTable;
    }

    public void setUseNewConnection(boolean useNewConnection) {
        this.useNewConnection = useNewConnection;
    }

    protected synchronized long getNextKey() throws DataAccessException {
        block28: {
            block27: {
                if (this.maxId != this.nextId) break block27;
                Connection con = null;
                Statement stmt = null;
                boolean mustRestoreAutoCommit = false;
                try {
                    if (this.useNewConnection) {
                        con = this.getDataSource().getConnection();
                        if (con.getAutoCommit()) {
                            mustRestoreAutoCommit = true;
                            con.setAutoCommit(false);
                        }
                    } else {
                        con = DataSourceUtils.getConnection((DataSource)this.getDataSource());
                    }
                    stmt = con.createStatement();
                    if (!this.useNewConnection) {
                        DataSourceUtils.applyTransactionTimeout((Statement)stmt, (DataSource)this.getDataSource());
                    }
                    String columnName = this.getColumnName();
                    String whereCondition = " where " + this.columnNameOfTable + " = \"" + this.columnValueOfTable + "\";";
                    ResultSet rs = stmt.executeQuery("select " + columnName + " from " + this.getIncrementerName() + whereCondition);
                    if (!rs.next()) {
                        throw new DataAccessResourceFailureException("fail to retrieve the max of the sequence column");
                    }
                    this.maxId = rs.getLong(1) + (long)this.getCacheSize();
                    try {
                        stmt.executeUpdate("update " + this.getIncrementerName() + " set " + columnName + " = " + this.maxId + whereCondition);
                    }
                    catch (SQLException ex) {
                        throw new DataAccessResourceFailureException("Could not increment " + columnName + " for " + this.getIncrementerName() + " sequence table", (Throwable)ex);
                    }
                    finally {
                        JdbcUtils.closeResultSet((ResultSet)rs);
                    }
                    this.nextId = this.maxId - (long)this.getCacheSize() + 1L;
                }
                catch (SQLException ex) {
                    try {
                        throw new DataAccessResourceFailureException("Could not obtain last_insert_id()", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.closeStatement(stmt);
                        if (con != null) {
                            if (this.useNewConnection) {
                                try {
                                    con.commit();
                                    if (mustRestoreAutoCommit) {
                                        con.setAutoCommit(true);
                                    }
                                }
                                catch (SQLException ignore) {
                                    throw new DataAccessResourceFailureException("Unable to commit new sequence value changes for " + this.getIncrementerName());
                                }
                                JdbcUtils.closeConnection((Connection)con);
                            } else {
                                DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
                            }
                        }
                        throw throwable;
                    }
                }
                JdbcUtils.closeStatement((Statement)stmt);
                if (con != null) {
                    if (this.useNewConnection) {
                        try {
                            con.commit();
                            if (mustRestoreAutoCommit) {
                                con.setAutoCommit(true);
                            }
                        }
                        catch (SQLException ignore) {
                            throw new DataAccessResourceFailureException("Unable to commit new sequence value changes for " + this.getIncrementerName());
                        }
                        JdbcUtils.closeConnection((Connection)con);
                    } else {
                        DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
                    }
                }
                break block28;
            }
            ++this.nextId;
        }
        return this.nextId;
    }
}

