/*
 * Decompiled with CFR 0.152.
 */
package com.github.damiansheldon.security.oauth2.client.endpoint;

import com.github.damiansheldon.security.oauth2.client.endpoint.WeworkOAuth2AuthorizationCodeGrantRequestEntityConverter;
import com.github.damiansheldon.security.oauth2.http.converter.WeworkOAuth2AccessTokenResponseConverter;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class WeworkAuthorizationCodeTokenResponseClient
implements OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> {
    private static final Log log = LogFactory.getLog(WeworkAuthorizationCodeTokenResponseClient.class);
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";
    private OAuth2AccessTokenResponse cachedOAuth2AccessTokenResponse;
    private Converter<OAuth2AuthorizationCodeGrantRequest, RequestEntity<?>> requestEntityConverter = new WeworkOAuth2AuthorizationCodeGrantRequestEntityConverter();
    private RestOperations restOperations;

    public WeworkAuthorizationCodeTokenResponseClient() {
        OAuth2AccessTokenResponseHttpMessageConverter converter = new OAuth2AccessTokenResponseHttpMessageConverter();
        converter.setTokenResponseConverter((Converter)new WeworkOAuth2AccessTokenResponseConverter());
        RestTemplate restTemplate = new RestTemplate(Arrays.asList(new FormHttpMessageConverter(), converter));
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        this.restOperations = restTemplate;
    }

    public OAuth2AccessTokenResponse getTokenResponse(OAuth2AuthorizationCodeGrantRequest authorizationGrantRequest) {
        Assert.notNull((Object)authorizationGrantRequest, (String)"authorizationCodeGrantRequest cannot be null");
        if (this.cachedOAuth2AccessTokenResponse != null && !this.isOAuth2AccessTokenExpire(this.cachedOAuth2AccessTokenResponse)) {
            return this.cachedOAuth2AccessTokenResponse;
        }
        this.cachedOAuth2AccessTokenResponse = this.fetchNewOauth2AccessToken(authorizationGrantRequest);
        return this.cachedOAuth2AccessTokenResponse;
    }

    public OAuth2AccessTokenResponse fetchNewOauth2AccessToken(OAuth2AuthorizationCodeGrantRequest authorizationGrantRequest) {
        ResponseEntity response;
        RequestEntity request = (RequestEntity)this.requestEntityConverter.convert((Object)authorizationGrantRequest);
        try {
            response = this.restOperations.exchange(request, OAuth2AccessTokenResponse.class);
        }
        catch (RestClientException ex) {
            log.warn((Object)"\u83b7\u53d6 Access token \u8c03\u7528\u5931\u8d25", (Throwable)ex);
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "An error occurred while attempting to retrieve the OAuth 2.0 Access Token Response: " + ex.getMessage(), null);
            throw new OAuth2AuthorizationException(oauth2Error, (Throwable)ex);
        }
        OAuth2AccessTokenResponse tokenResponse = (OAuth2AccessTokenResponse)response.getBody();
        if (CollectionUtils.isEmpty((Collection)tokenResponse.getAccessToken().getScopes())) {
            tokenResponse = OAuth2AccessTokenResponse.withResponse((OAuth2AccessTokenResponse)tokenResponse).scopes(authorizationGrantRequest.getClientRegistration().getScopes()).build();
        }
        return tokenResponse;
    }

    private boolean isOAuth2AccessTokenExpire(OAuth2AccessTokenResponse accessTokenResponse) {
        if (accessTokenResponse == null) {
            return true;
        }
        if (accessTokenResponse.getAccessToken() == null) {
            return true;
        }
        Instant expiresAt = accessTokenResponse.getAccessToken().getExpiresAt();
        Instant now = Instant.now();
        return expiresAt.isBefore(now);
    }
}

